/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#ifndef MONOMER_CROSS_LINK_DLG_HPP
#define MONOMER_CROSS_LINK_DLG_HPP


/////////////////////// Qt includes
#include <QMainWindow>


/////////////////////// Local includes
#include "ui_monomerCrossLinkDlg.h"
#include "sequenceEditorWnd.hpp"


namespace massXpert
{

  class Monomer;


  class MonomerCrossLinkDlg : public QDialog
  {
    Q_OBJECT
  
    private:
    Ui::MonomerCrossLinkDlg m_ui;
    SequenceEditorWnd *mp_editorWnd;

    bool m_polymerSequenceModified;
    
    QColor m_crossLinkColor;
    int m_crossLinkPixelSize;
  
    bool populateCrossLinkerList();
    bool populateCrossLinkedMonomerList();
    bool populateCrossLinkList(bool = true);
  
    bool parseTargetMonomerString(QList<const Monomer *> *);
  
    void closeEvent(QCloseEvent *event); 

  public:
    MonomerCrossLinkDlg(QWidget *);
    ~MonomerCrossLinkDlg();
  
  public slots:
    void crossLink();
    void uncrossLink();
    
    void crossLinkerListWidgetItemSelectionChanged();

    void crossLinkedMonomerListWidgetItemSelectionChanged();
    void crossLinkedMonomerListWidgetItemActivated(QListWidgetItem *);
    
    void crossLinkListWidgetItemSelectionChanged();
    void crossLinkListWidgetItemActivated(QListWidgetItem *);
    
    void displayAllCrossLinksChanged(int);
    void crossLinkChangedSlot(Polymer *);
    
    void polymerSequenceModifiedSlot();
  };

} // namespace massXpert


#endif // MONOMER_CROSS_LINK_DLG_HPP
