/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "TemporaryObject.h"

#include "IconFactory.h"
#include "Request.h"
#include "Language.h"
#include "IconClass.h"
#include "Dependancy.h"

#include "mars.h"

static string next_name()
{
	static int i = 0;
	char buf[80];
	sprintf(buf,"Temp%04d",i++);
	return buf;
}

TemporaryObject::TemporaryObject(IconObject* ref,const Request& r,const IconClass* c):
	IconObject(0,c ? *c : IconClass::find(r.getVerb()),next_name(),0),
	ref_(ref), request_(r)
{
  	cout << "-->  TemporaryObject::TemporaryObject() for" << *ref_ << endl;
	r.print();
	cout << "<--  TemporaryObject::TemporaryObject() for" << *ref_ << endl;
}

TemporaryObject::~TemporaryObject()
{
	cout << "TemporaryObject::~TemporaryObject() for " << *ref_ << endl;
}

Folder* TemporaryObject::parent() const
{
	return ref_->parent();
}

void TemporaryObject::createFiles()
{
}

Request TemporaryObject::request() const
{
	request_.print();
	return language().expand(request_,EXPAND_NO_DEFAULT|EXPAND_2ND_NAME);
}

void TemporaryObject::request(const Request& r)
{
	request_ = r;
}

Path TemporaryObject::pathForShellTask() const
{
    const char* path = request_("PATH");
    if ( path ) {
        const char* path = request_("PATH");
        return string(path);

    }
	return string("/dev/null");
}

Path TemporaryObject::path() const
{
	return string("/dev/null");
}


Path TemporaryObject::dotPath() const
{
	return string("/dev/null");
}

Path TemporaryObject::embeddedPath() const
{
	return string("/dev/null");
}

string TemporaryObject::fullName() const
{
	return ref_->fullName() + "/" + name();
}
string TemporaryObject::relativeName(IconObject* other) const
{
	return ref_->relativeName(other);
}

string TemporaryObject::makeFullName(const string& name) const
{
	return ref_->makeFullName(name);
}

Folder* TemporaryObject::embeddedFolder(const string& n,bool create) const
{
	return ref_->embeddedFolder(n,create);
}

Folder* TemporaryObject::embeddedFolder(bool create) const
{
	return ref_->embeddedFolder(create);
}

#if 0
Log& TemporaryObject::log()
{
	return ref_->log();
}
#endif

bool TemporaryObject::rename(const string& s)
{
	name_ = s;
	return true;
}

bool TemporaryObject::renamable() const
{
	return true;
}

bool TemporaryObject::temporary() const
{
	return true;
}

