/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconHolder_H
#include "IconHolder.h"
#endif



#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif


IconHolder::IconHolder()
	
{
}

IconHolder::~IconHolder()
{
}

void IconHolder::install(Widget w)
{
	DragWindow::install(w);
}

void IconHolder::clear()
{
	removeAllIcons();

	for(vector<IconObjectH>::iterator j = icons_.begin(); j != icons_.end(); ++j)
		(*j)->removeObserver(this);

	icons_.clear();
}


void IconHolder::add(IconObject* o)
{	

	vector<IconObjectH>::iterator k = find(icons_.begin(),icons_.end(),o);
	if(k != icons_.end()) return;
	
	if ( !accept(o) ) 
		return;

	if ( unique() ) clear();

	addIcon(o);

	o->addObserver(this);
	icons_.push_back(o);

}

bool IconHolder::unique() 
{
	return false;
}



void IconHolder::changed(IconObject* o)
{
	refreshIcon(o);
	cout << "IconHolder::modified " << *o << endl;

}

void IconHolder::edited(IconObject* o)
{
	openIcon(o);
}
void IconHolder::closed(IconObject* o)
{
	closeIcon(o);
}


void IconHolder::doubleClick(IconObject* o)
{
	if(o) o->edit();
}

void IconHolder::move(IconObject*,int,int,IconObject*)
{
}

void IconHolder::rename(IconObject*,const string&)
{
}


void IconHolder::clearCurrent()
{
	for(vector<IconObjectH>::iterator j = current_.begin(); j != current_.end(); ++j)
		clear(*j);
	
	current_.clear();
}


void IconHolder::clear(IconObject* o)
{
	removeIcon(o);

	o->removeObserver(this);
	vector<IconObjectH>::iterator k = find(icons_.begin(),icons_.end(),o);
	if(k != icons_.end()) icons_.erase(k);
}


