/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MATRIXP_H
#define MATRIXP_H

/*
** Class Part
*/

typedef struct _MatrixClassPart 
{
	int	ignore;
} MatrixClassPart;

typedef struct _MatrixClassRec
{
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	MatrixClassPart		group_class;
} MatrixClassRec;

extern MatrixClassRec matrixClassRec;

/*
** Instance part
*/

typedef struct _MatrixPart
{
	/* Shadow Attributes */

	Dimension	shadow_thickness;
	Pixel		top_shadow_color;
	Pixel		bottom_shadow_color;

	/* Compatibility with Motif */

	caddr_t		user_data;

	/* Callbacks */

	XtCallbackList	exposecallback;
	XtCallbackList	resizecallback;

	/* Matrix Organization Atributes */

	int		max_cols;
	Boolean		shade_attach;
	Dimension	margin;
	Dimension	spacing;

	int		create_scroll;
	Boolean		manage_scroll;

	int		*row_array, *col_array;

	/* Derived Organization attributes */

	Widget		serie_first, serie_last;
	int		nrows_used, ncols_used;

	/* Private resources */

	GC		gc_top;		/* GC for shadow	*/
	GC		gc_bot;		/* GC for shadow	*/
	GC		gc_drag;	/* GC for drag &
					   rubber banding	*/
	Widget		scroll_bar;	/* Scroll bar widget	*/
	char		companion;	/* flag when creating
					   companion widget	*/
	int		row_array_size, col_array_size;

} MatrixPart;

typedef struct _MatrixRec
{
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
	MatrixPart	matrix;

} MatrixRec;

/*
** Part attached to children
*/

typedef struct _MatrixConstraintsPart
{
	int       ix, iy;		/* position in matrix	*/

	Widget    next, previous;	/* double linked list	*/

	/* Used only by top of the list elements */

	Widget    serie_next,		/* double linked list   */
	          serie_previous;	/* for series		*/

	Widget    scroll_bar;		/* scroll bar widget	*/

	/* Origin and size */

	Dimension px, py;
	Dimension sizex, sizey;

} MatrixConstraintsPart;


typedef struct _MatrixConstraintsRec
{
	MatrixConstraintsPart matrix;

} MatrixConstraintsRec, *MatrixConstraints;

#define MATRIX_CONSTRAINT(w) ( (MatrixConstraints) ( (w)->core.constraints ) )
#define CONSTR(w) (MATRIX_CONSTRAINT(w)->matrix) 

#endif
