---
title: Insiders
---

# Insiders

Material for MkDocs follows the __sponsorware__ release strategy, which means
that new features are first exclusively released to sponsors as part of
[Insiders]. Read on to learn [what sponsorships achieve],
[how to become a sponsor] to get access to Insiders, and [what's in it for you]!

<!-- <figure class="mdx-video" markdown>
  <div class="mdx-video__inner">
    <iframe src="https://streamable.com/e/yslhdu" allowfullscreen></iframe>
  </div>
  <figcaption markdown>

This documentation is built with Insiders
[squidfunk.github.io/mkdocs-material][Material for MkDocs]

  </figcaption>
</figure> -->

  [Insiders]: #what-is-insiders
  [what sponsorships achieve]: #what-sponsorships-achieve
  [how to become a sponsor]: #how-to-become-a-sponsor
  [what's in it for you]: #whats-in-it-for-me
  [Material for MkDocs]: https://squidfunk.github.io/mkdocs-material/

## What is Insiders?

Material for MkDocs Insiders is a private fork of Material for MkDocs, hosted as
a private GitHub repository. Almost[^1] [all new features][what's in it for you]
are developed as part of this fork, which means that they are immediately
available to all eligible sponsors, as they are made collaborators of this
repository.

  [^1]:
    In general, every new feature is first exclusively released to sponsors, but
    sometimes upstream dependencies like [Python Markdown Extensions] enhance
    existing features that must be supported by Material for MkDocs.

Every feature is tied to a [funding goal] in monthly subscriptions. When a
funding goal is hit, the features that are tied to it are merged back into
Material for MkDocs and released for general availability, making them available
to all users. Bugfixes are always released in tandem.

Sponsorships start as low as [__$15 a month__][how to become a sponsor].[^2]

  [^2]:
    Note that $15 a month is the minimum amount to become eligible for
    Insiders. While GitHub Sponsors also allows to sponsor lower amounts or
    one-time amounts, those can't be granted access to Insiders due to
    technical reasons.

  [Python Markdown Extensions]: https://facelessuser.github.io/pymdown-extensions/
  [funding goal]: #funding

## What sponsorships achieve

Sponsorships make this project sustainable, as they buy the maintainers of this
project time – a very scarce resource – which is spent on the development of new
features, bug fixing, stability improvement, issue triage and general support.
The biggest bottleneck in Open Source is time.[^3]

  [^3]:
    Making an Open Source project sustainable is exceptionally hard: maintainers
    burn out, projects are abandoned. That's not great and very unpredictable.
    The sponsorware model ensures that if you decide to use Material for MkDocs,
    you can be sure that bugs are fixed quickly and new features are added
    regularly.

If you're unsure if you should sponsor this project, check out the list of
[completed funding goals] to learn whether you're already using features that
were developed with the help of sponsorships. You're most likely using at least
a handful of them, [thanks to our awesome sponsors]!

  [completed funding goals]: #goals-completed
  [thanks to our awesome sponsors]: #how-to-become-a-sponsor

<figure style="min-width:15.6rem">
  <blockquote class="twitter-tweet" data-conversation="none" data-dnt="true">
    <a href="https://twitter.com/WillingCarol/status/1603416470616088576?ref_src=twsrc%5Etfw"></a>
  </blockquote>
  <script async src="https://platform.twitter.com/widgets.js"></script>
</figure>

## What's in it for me?

The moment you [become a sponsor][how to become a sponsor], you'll get __immediate
access to 23 additional features__ that you can __start using now__, and
which are currently exclusively available to sponsors:

<div class="mdx-columns" markdown>

- [x] [Projects plugin] :material-alert-decagram:{ .mdx-pulse title="Added on July 29, 2023" }
- [x] [Instant prefetching] :material-alert-decagram:{ .mdx-pulse title="Added on June 15, 2023" }
- [x] [Social plugin: custom layouts] :material-alert-decagram:{ .mdx-pulse title="Added on May 8, 2023" }
- [x] [Social plugin: background images] :material-alert-decagram:{ .mdx-pulse title="Added on May 8, 2023" }
- [x] [Code range selection]
- [x] [Code annotations: custom selectors]
- [x] [Privacy plugin: optimization support]
- [x] [Optimize plugin]
- [x] [Navigation path] (Breadcrumbs)
- [x] [Typeset plugin]
- [x] [Privacy plugin: external links]
- [x] [Navigation subtitles]
- [x] [Tags plugin: allow list] + [custom sorting]
- [x] [Blog plugin: custom index pages]
- [x] [Blog plugin: related links]
- [x] [Meta plugin]
- [x] [Tags plugin: additional indexes]
- [x] [Document contributors]
- [x] [Automatic light / dark mode]
- [x] [Content tabs: anchor links]
- [x] [Tooltips]
- [x] [Card grids]
- [x] [Privacy plugin]

</div>

New features are added every other week. Be sure to come back.

## How to become a sponsor

Thanks for your interest in sponsoring! In order to become an eligible sponsor
with your GitHub account, visit [squidfunk's sponsor profile], and complete
a sponsorship of __$15 a month or more__. You can use your individual or
organization GitHub account for sponsoring.

__Important__: If you're sponsoring @squidfunk through a GitHub organization,
please send a short email to sponsors@squidfunk.com with the name of your
organization and the GitHub account of the individual that should be added as a
collaborator.[^4]

You can cancel your sponsorship anytime.[^5]

  [^4]:
    It's currently not possible to grant access to each member of an
    organization, as GitHub only allows for adding users. Thus, after
    sponsoring, please send an email to sponsors@squidfunk.com, stating which
    account should become a collaborator of the Insiders repository. We're
    working on a solution which will make access to organizations much simpler.
    To ensure that access is not tied to a particular individual GitHub account,
    create a bot account (i.e. a GitHub account that is not tied to a specific
    individual), and use this account for the sponsoring. After being added to
    the list of collaborators, the bot account can create a private fork of the
    private Insiders GitHub repository, and grant access to all members of the
    organizations.

  [^5]:
    If you cancel your sponsorship, GitHub schedules a cancellation request
    which will become effective at the end of the billing cycle. This means
    that even though you cancel your sponsorship, you will keep your access to
    Insiders as long as your cancellation isn't effective. All charges are
    processed by GitHub through Stripe. As we don't receive any information
    regarding your payment, and GitHub doesn't offer refunds, sponsorships are
    non-refundable.

[:octicons-heart-fill-24:{ .mdx-heart } &nbsp; Join our <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span> awesome sponsors][squidfunk's sponsor profile]{ .md-button .md-button--primary .mdx-sponsorship-button }

<hr />

<div class="mdx-premium" markdown>

**Silver sponsors**:

[![FastAPI]{ style="height: 120px" }](https://fastapi.tiangolo.com/){ target=_blank title="FastAPI" }

**Bronze sponsors**:

[![Cirrus CI]](https://cirrus-ci.org/){ target=_blank title="Cirrus CI" }
[![Basler]](https://docs.baslerweb.com/){ target=_blank title="Basler" }
[![KX]](https://kx.com/){ target=_blank title="KX Systems" }
[![Manticore Games]](https://www.manticoregames.com/){ target=_blank title="Manticore Games" }
[![Prefect]](https://orion-docs.prefect.io/){ target=_blank title="Prefect" }
[![Datadog]](https://datadoghq.com/){ target=_blank title="Datadog" }
[![Zenoss]](https://zenoss.com/){ target=_blank title="Zenoss" }
[![Posit]](https://docs.posit.co){ target=_blank title="Posit" }
[![n8n]](https://n8n.io){ target=_blank title="n8n" }
[![Dogado]](https://www.dogado.de){ target=_blank title="Dogado" }
[![World Wide Technology]](https://wwt.com){ target=_blank title="World Wide Technology" }
[![Coda]](https://coda.io){ target=_blank title="Coda" }
[![Elastic]](https://elastic.co){ target=_blank title="Elastic" }
[![IP Fabric]](https://ipfabric.io/){ target=_blank title="IP Fabric" }
[![Apex.AI]](https://www.apex.ai/){ target=_blank title="Apex.AI" }
[![Jitterbit]](https://jitterbit.com/){ target=_blank title="Jitterbit" }
[![Sparkfun]](https://sparkfun.com/){ target=_blank title="Sparkfun Electronics" }
[![Eccenca]](https://eccenca.com/){ target=_blank title="Eccenca" }
[![Neptune]](https://neptune.ai/){ target=_blank title="Neptune" }
[![RackN]](https://rackn.com/){ target=_blank title="RackN" }
[![CivicActions]](https://civicactions.com/){ target=_blank title="CivicActions" }
[![bitcrowd]](https://bitcrowd.net/){ target=_blank title="bitcrowd" }
[![GetScreen.me]](https://getscreen.me/){ target=_blank title="GetScreen.me" }
[![BotCity]](https://botcity.dev/){ target=_blank title="BotCity" }
[![Springer Nature Technology]](https://www.springernature.com/gp){ target=_blank title="Springer Nature Technology" }
[![Kolena]](https://kolena.io/){ target=_blank title="Kolena" }
[![Evergiving]](https://www.evergiving.com/){ target=_blank title="Evergiving" }
[![Koor]](https://koor.tech/){ target=_blank title="Koor" }
[![Astral]](https://astral.sh/){ target=_blank title="Astral" }
[![Oikolab]](https://oikolab.com/){ target=_blank title="Oikolab" }
[![Bühler Group]](https://www.buhlergroup.com/){ target=_blank title="Bühler Group" }
[![Transformation Flow]](https://transformationflow.io/){ target=_blank title="Transformation Flow" }

</div>

  [FastAPI]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-fastapi.png
  [Cirrus CI]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-cirrus-ci.png
  [Basler]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-basler.png
  [KX]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-kx.png
  [Manticore Games]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-manticore-games.png
  [Prefect]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-prefect.png
  [Datadog]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-datadog.png
  [Zenoss]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-zenoss.png
  [Posit]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-posit.png
  [n8n]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-n8n.png
  [Dogado]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-dogado.png
  [World Wide Technology]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-wwt.png
  [Coda]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-coda.png
  [Elastic]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-elastic.png
  [IP Fabric]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-ip-fabric.png
  [Apex.AI]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-apex-ai.png
  [Jitterbit]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-jitterbit.png
  [Sparkfun]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-sparkfun.png
  [Eccenca]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-eccenca.png
  [Neptune]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-neptune-ai.png
  [Cash App]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-cashapp.png
  [RackN]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-rackn.png
  [CivicActions]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-civic-actions.png
  [bitcrowd]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-bitcrowd.png
  [GetScreen.me]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-getscreenme.png
  [BotCity]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-botcity.png
  [Springer Nature Technology]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-sn-technology.png
  [Kolena]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-kolena.png
  [Evergiving]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-evergiving.png
  [Koor]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-koor.png
  [Astral]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-astral.png
  [Oikolab]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-oikolab.png
  [Bühler Group]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-buhler.png
  [Transformation Flow]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-transformationflow.png

<hr />

<div class="mdx-sponsorship" data-mdx-component="sponsorship" hidden>
  <div class="mdx-sponsorship__list"></div>
  <small>
    If you sponsor publicly, you're automatically added here with a link to
    your profile and avatar to show your support for Material for MkDocs.
    Alternatively, if you wish to keep your sponsorship private, you'll be a
    silent +1. You can select visibility during checkout and change it
    afterwards.
  </small>
</div>

  [squidfunk's sponsor profile]: https://github.com/sponsors/squidfunk?metadata_origin=docs

## Funding <span class="mdx-sponsorship-total" data-mdx-component="sponsorship-total"></span>

### Goals

The following section lists all funding goals. Each goal contains a list of
features prefixed with a checkmark symbol, denoting whether a feature is
:octicons-check-circle-fill-24:{ style="color: #00e676" } already available or
:octicons-check-circle-fill-24:{ style="color: var(--md-default-fg-color--lightest)" } planned, but not yet implemented. When the funding goal is hit, the features
are released for general availability.

#### $ 14,000 – Goat's Horn

- [x] [Privacy plugin]
- [x] [Card grids]
- [x] [Tooltips]
- [x] [Content tabs: anchor links]
- [x] [Automatic light / dark mode]
- [x] [Document contributors]

  [Privacy plugin]: ../setup/ensuring-data-privacy.md
  [Card grids]: ../reference/grids.md
  [Tooltips]: ../reference/tooltips.md
  [Content tabs: anchor links]: ../reference/content-tabs.md#anchor-links
  [Automatic light / dark mode]: ../setup/changing-the-colors.md#automatic-light-dark-mode
  [Document contributors]: ../setup/adding-a-git-repository.md#document-contributors

#### $ 16,000 – Chipotle

- [x] [Meta plugin]
- [x] [Blog plugin: related links]
- [x] [Blog plugin: custom index pages]
- [x] [Tags plugin: additional indexes]
- [x] [Tags plugin: allow list] + [custom sorting]
- [x] [Navigation subtitles]

  [Meta plugin]: ../plugins/meta.md
  [Blog plugin: related links]: ../setup/setting-up-a-blog.md#adding-related-links
  [Blog plugin: custom index pages]: ../setup/setting-up-a-blog.md#custom-index-pages
  [Tags plugin: additional indexes]: ../setup/setting-up-tags.md#+tags.tags_extra_files
  [Tags plugin: allow list]: ../setup/setting-up-tags.md#+tags.tags_allowed
  [custom sorting]: ../setup/setting-up-tags.md#+tags.tags_compare
  [Navigation subtitles]: ../reference/index.md#setting-the-page-subtitle

#### $ 20,000 – Jalapeño

- [x] [Optimize plugin]
- [x] [Typeset plugin]
- [x] [Navigation path] (Breadcrumbs)
- [x] [Privacy plugin: optimization support]
- [x] [Privacy plugin: external links]
- [x] [Instant prefetching]

  [Optimize plugin]: ../plugins/optimize.md
  [Typeset plugin]: ../plugins/typeset.md
  [Privacy plugin: external links]: ../setup/ensuring-data-privacy.md#+privacy.links
  [Privacy plugin: optimization support]: ../setup/ensuring-data-privacy.md#+privacy.assets_include
  [Navigation path]: ../setup/setting-up-navigation.md#navigation-path
  [Instant prefetching]: ../setup/setting-up-navigation.md#instant-prefetching

#### $ 24,000 – Blockpaprika

- [x] [Projects plugin]
- [x] [Social plugin: custom layouts]
- [x] [Social plugin: background images]
- [x] [Code range selection]
- [x] [Code annotations: custom selectors]
- [ ] Code line wrap button

  [Projects plugin]: ../plugins/projects.md
  [Social plugin: custom layouts]: ../setup/setting-up-social-cards.md#customization
  [Social plugin: background images]: ../setup/setting-up-social-cards.md#+social.cards_layout_params.background_image
  [Code range selection]: ../reference/code-blocks.md#code-selection-button
  [Code annotations: custom selectors]: ../reference/code-blocks.md#custom-selectors

### Goals completed

This section lists all funding goals that were previously completed, which means
that those features were part of Insiders, but are now generally available and
can be used by all users.

#### $ 12,000 – Piri Piri

- [x] [Blog plugin]
- [x] [Chinese search support]
- [x] [Annotations]
- [x] [Navigation icons]
- [x] [Navigation pruning]
- [x] [Navigation status]

  [Blog plugin]: ../setup/setting-up-a-blog.md
  [Chinese search support]: ../blog/posts/chinese-search-support.md
  [Annotations]: ../reference/annotations.md
  [Navigation icons]: ../reference/index.md#setting-the-page-icon
  [Navigation pruning]: ../setup/setting-up-navigation.md#navigation-pruning
  [Navigation status]: ../reference/index.md#setting-the-page-status

#### $ 10,000 – Carolina Reaper

- [x] [Brand new search plugin]
- [x] [Rich search previews]
- [x] [Tokenizer with lookahead]
- [x] [Advanced search highlighting]
- [x] [Excluding content from search]
- [x] [Offline plugin]

  [Brand new search plugin]: ../blog/posts/search-better-faster-smaller.md
  [Rich search previews]: ../blog/posts/search-better-faster-smaller.md#rich-search-previews
  [Tokenizer with lookahead]: ../blog/posts/search-better-faster-smaller.md#tokenizer-lookahead
  [Advanced search highlighting]: ../blog/posts/search-better-faster-smaller.md#accurate-highlighting
  [Excluding content from search]: ../setup/setting-up-site-search.md#search-exclusion
  [Offline plugin]: ../setup/building-for-offline-usage.md

#### $ 8,000 – Scotch Bonnet

- [x] [Social cards]
- [x] Code annotations: anchor links
- [x] [Code annotations: strip comments]
- [x] [Tag icons]
- [x] [Table of contents anchor following]
- [x] Sidebars automatically scroll to active item

  [Social cards]: ../setup/setting-up-social-cards.md
  [Code annotations: strip comments]: ../reference/code-blocks.md#stripping-comments
  [Tag icons]: ../setup/setting-up-tags.md#tag-icons-and-identifiers
  [Table of contents anchor following]: ../setup/setting-up-navigation.md#anchor-following

#### $ 7,000 – Royal Gold

- [x] [Cookie consent]
- [x] [Was this page helpful?]
- [x] [Dismissable announcement bar]

  [Cookie consent]: ../setup/ensuring-data-privacy.md#cookie-consent
  [Was this page helpful?]: ../setup/setting-up-site-analytics.md#was-this-page-helpful
  [Dismissable announcement bar]: ../setup/setting-up-the-header.md#mark-as-read

#### $ 6,000 – Trinidad Scorpion

- [x] [Boosting pages in search]
- [x] [Custom admonition icons]
- [x] [Linking content tabs]

  [Boosting pages in search]: ../setup/setting-up-site-search.md#search-boosting
  [Custom admonition icons]: ../reference/admonitions.md#admonition-icons
  [Linking content tabs]: ../reference/content-tabs.md#linked-content-tabs

#### $ 5,000 – Aji Panca

- [x] [Mermaid.js integration]
- [x] Stay on page when switching versions
- [x] [Tags with search integration]

  [Mermaid.js integration]: ../reference/diagrams.md
  [Tags with search integration]: ../setup/setting-up-tags.md

#### $ 4,000 – Ghost Pepper

- [x] [Anchor tracking]
- [x] [Code annotations]
- [x] [Version warning]

  [Anchor tracking]: ../setup/setting-up-navigation.md#anchor-tracking
  [Code annotations]: ../reference/code-blocks.md#adding-annotations
  [Version warning]: ../setup/setting-up-versioning.md#version-warning

#### $ 3,000 – Caribbean Red

- [x] [Sticky navigation tabs]
- [x] [Section index pages]
- [x] [Remove generator notice]

  [Sticky navigation tabs]: ../setup/setting-up-navigation.md#sticky-navigation-tabs
  [Section index pages]: ../setup/setting-up-navigation.md#section-index-pages
  [Remove generator notice]: ../setup/setting-up-the-footer.md#generator-notice

#### $ 2,500 – Biquinho Vermelho

- [x] [Search suggestions]
- [x] [Search highlighting]
- [x] [Search sharing]

  [Search suggestions]: ../setup/setting-up-site-search.md#search-suggestions
  [Search highlighting]: ../setup/setting-up-site-search.md#search-highlighting
  [Search sharing]: ../setup/setting-up-site-search.md#search-sharing

#### $ 2,000 – Black Pearl

- [x] Latest release tag
- [x] [Color palette toggle]
- [x] [Back-to-top button]

  [Color palette toggle]: ../setup/changing-the-colors.md#color-palette-toggle
  [Back-to-top button]: ../setup/setting-up-navigation.md#back-to-top-button

#### $ 1,500 – Bhut Jolokia

- [x] [Admonition inline blocks]
- [x] [Site language selection]
- [x] [Versioning]

  [Admonition inline blocks]: ../reference/admonitions.md#inline-blocks
  [Site language selection]: ../setup/changing-the-language.md#site-language-selector
  [Versioning]: ../setup/setting-up-versioning.md#versioning

#### $ 1,000 – Prairie Fire

- [x] [Navigation sections]
- [x] [Navigation expansion]
- [x] [Hiding the sidebars]
- [x] [Table of contents in navigation]
- [x] [Header hides on scroll]

  [Navigation sections]: ../setup/setting-up-navigation.md#navigation-sections
  [Navigation expansion]: ../setup/setting-up-navigation.md#navigation-expansion
  [Hiding the sidebars]: ../setup/setting-up-navigation.md#hiding-the-sidebars
  [Table of contents in navigation]: ../setup/setting-up-navigation.md#navigation-integration
  [Header hides on scroll]: ../setup/setting-up-the-header.md#automatic-hiding

#### $ 500 – Madame Jeanette

- [x] Improved search result grouping
- [x] Improved search result relevance and scoring
- [x] Missing query terms in search results

## Frequently asked questions

### Compatibility

_We're building an open source project and want to allow outside collaborators
to run and build our documentation locally without having access to Insiders.
Is this still possible?_

Yes. Insiders is compatible with Material for MkDocs. Almost all new features
and configuration options are either backward-compatible or implemented behind
feature flags. When working with outside collaborators, it should be rarely
necessary to change the general appearance of your site. Most Insiders features
enhance the overall experience, e.g. by adding icons to pages or providing a
feedback widget. While these features add value for the user of your site, they
shouldn't be necessary for previewing when making changes to content. Currently,
the only content-related features in Insiders that can't be properly previewed
by non-Insiders users are:

- [Annotations]
- [Card grids]

This means that outside collaborators are able to build the documentation
locally with Material for MkDocs and when they push their changes, your CI
pipeline will build it with Insiders. When using built-in plugins that are
exclusive to Insiders, it's recommended to split configuration into a base
`mkdocs.yml` and one with plugin overrides via [configuration inheritance].

See the [getting started guide] for more information.

  [configuration inheritance]: https://www.mkdocs.org/user-guide/configuration/#configuration-inheritance
  [getting started guide]: getting-started.md#caveats

### Payment

_We don't want to pay for sponsorship every month. Are there any other options?_

Yes. You can sponsor on a yearly basis by [switching your GitHub account to a
yearly billing cycle][billing cycle]. If for some reason you cannot do that, you
could also create a dedicated GitHub account with a yearly billing cycle, which
you only use for sponsoring (some sponsors already do that).

If you have any problems or further questions, please reach out to
sponsors@squidfunk.com.

  [billing cycle]: https://docs.github.com/en/github/setting-up-and-managing-billing-and-payments-on-github/changing-the-duration-of-your-billing-cycle

### Terms

_Are we allowed to use Insiders under the same terms and conditions as
Material for MkDocs?_

Yes. Whether you're an individual or a company, you may use _Material for MkDocs
Insiders_ precisely under the same terms as Material for MkDocs, which are given
by the [MIT license]. However, we kindly ask you to respect our
__fair use policy__:

- Please __don't distribute the source code__ of Insiders. You may freely use
  it for public, private or commercial projects, privately fork or mirror it,
  but please don't make the source code public, as it would counteract the
  sponsorware strategy.

- If you cancel your subscription, you're automatically removed as a
  collaborator and will miss out on all future updates of Insiders. However, you
  may __use the latest version__ that's available to you __as long as you like__.
  Just remember that [GitHub deletes private forks].

  [MIT license]: ../license.md
  [GitHub deletes private forks]: https://docs.github.com/en/github/setting-up-and-managing-your-github-user-account/removing-a-collaborator-from-a-personal-repository
