/* Profile.c generated by valac 0.16.1, the Vala compiler
 * generated from Profile.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define TYPE_PROFILE (profile_get_type ())
#define PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROFILE, Profile))
#define PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROFILE, ProfileClass))
#define IS_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROFILE))
#define IS_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROFILE))
#define PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROFILE, ProfileClass))

typedef struct _Profile Profile;
typedef struct _ProfileClass ProfileClass;
typedef struct _ProfilePrivate ProfilePrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Profile {
	GObject parent_instance;
	ProfilePrivate * priv;
	GKeyFile* keyFile;
};

struct _ProfileClass {
	GObjectClass parent_class;
};


static gpointer profile_parent_class = NULL;

GType profile_get_type (void) G_GNUC_CONST;
enum  {
	PROFILE_DUMMY_PROPERTY
};
void profile_saveWindowSize (Profile* self, gint w, gint h);
void profile_saveWindowPanedPosition (Profile* self, gint pos);
gint profile_getWindowPanedPosition (Profile* self);
gint profile_getWindowWidth (Profile* self);
gint profile_getWindowHeight (Profile* self);
gboolean profile_load (Profile* self, const gchar* filename, GtkWindow* window);
void profile_toString (Profile* self);
void profile_save (Profile* self, const gchar* filename, GtkWindow* window);
Profile* profile_new (void);
Profile* profile_construct (GType object_type);
static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void profile_finalize (GObject* obj);


void profile_saveWindowSize (Profile* self, gint w, gint h) {
	gint _tmp0_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = w;
	if (_tmp0_ > 0) {
		GKeyFile* _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->keyFile;
		_tmp2_ = w;
		g_key_file_set_integer (_tmp1_, "window", "width", _tmp2_);
	}
	_tmp3_ = h;
	if (_tmp3_ > 0) {
		GKeyFile* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->keyFile;
		_tmp5_ = h;
		g_key_file_set_integer (_tmp4_, "window", "height", _tmp5_);
	}
}


void profile_saveWindowPanedPosition (Profile* self, gint pos) {
	GKeyFile* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->keyFile;
	_tmp1_ = pos;
	g_key_file_set_integer (_tmp0_, "window", "paned_pos", _tmp1_);
}


gint profile_getWindowPanedPosition (Profile* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GKeyFile* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_;
		_tmp0_ = self->keyFile;
		_tmp1_ = g_key_file_get_integer (_tmp0_, "window", "paned_pos", &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch24_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = _tmp2_;
		return result;
	}
	goto __finally24;
	__catch24_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally24:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gint profile_getWindowWidth (Profile* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GKeyFile* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_;
		_tmp0_ = self->keyFile;
		_tmp1_ = g_key_file_get_integer (_tmp0_, "window", "width", &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch25_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = _tmp2_;
		return result;
	}
	goto __finally25;
	__catch25_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally25:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gint profile_getWindowHeight (Profile* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GKeyFile* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_;
		_tmp0_ = self->keyFile;
		_tmp1_ = g_key_file_get_integer (_tmp0_, "window", "height", &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch26_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		result = _tmp2_;
		return result;
	}
	goto __finally26;
	__catch26_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = -1;
		_g_error_free0 (e);
		return result;
	}
	__finally26:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


gboolean profile_load (Profile* self, const gchar* filename, GtkWindow* window) {
	gboolean result = FALSE;
	gchar* f = NULL;
	gboolean default_profile;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	default_profile = FALSE;
	_tmp0_ = filename;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		default_profile = TRUE;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_strdup_printf ("%s/moserial.conf", _tmp1_);
		_g_free0 (f);
		f = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = filename;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (f);
		f = _tmp4_;
	}
	{
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->keyFile;
		_tmp6_ = f;
		g_key_file_load_from_file (_tmp5_, _tmp6_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch27_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch27_g_file_error;
			}
			_g_free0 (f);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = TRUE;
		_g_free0 (f);
		return result;
	}
	goto __finally27;
	__catch27_g_key_file_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, "%s\n", _tmp9_);
		result = TRUE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	goto __finally27;
	__catch27_g_file_error:
	{
		GError* e = NULL;
		gboolean _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = default_profile;
		if (!_tmp10_) {
			GtkWindow* _tmp11_;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			GtkMessageDialog* _tmp16_;
			GtkMessageDialog* _tmp17_;
			GtkMessageDialog* errorDialog;
			GtkMessageDialog* _tmp18_;
			GtkMessageDialog* _tmp19_;
			_tmp11_ = window;
			_tmp12_ = _ ("Error: Could not open file");
			_tmp13_ = filename;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp11_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s: %s\n%s", _tmp12_, _tmp13_, _tmp15_);
			_tmp17_ = g_object_ref_sink (_tmp16_);
			errorDialog = _tmp17_;
			_tmp18_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp18_);
			_tmp19_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp19_);
			_g_object_unref0 (errorDialog);
		}
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (f);
		return result;
	}
	__finally27:
	_g_free0 (f);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void profile_toString (Profile* self) {
	gsize s = 0UL;
	FILE* _tmp0_;
	GKeyFile* _tmp1_;
	gsize _tmp2_ = 0UL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->keyFile;
	_tmp3_ = g_key_file_to_data (_tmp1_, &_tmp2_, NULL);
	s = _tmp2_;
	_tmp4_ = _tmp3_;
	fprintf (_tmp0_, "%s\n", _tmp4_);
	_g_free0 (_tmp4_);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void profile_save (Profile* self, const gchar* filename, GtkWindow* window) {
	GFile* file = NULL;
	GFileOutputStream* fos = NULL;
	gchar* f = NULL;
	gboolean default_profile;
	const gchar* _tmp0_;
	const gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	default_profile = FALSE;
	_tmp0_ = filename;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		default_profile = TRUE;
		_tmp1_ = g_get_user_config_dir ();
		_tmp2_ = g_strdup_printf ("%s/moserial.conf", _tmp1_);
		_g_free0 (f);
		f = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = filename;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (f);
		f = _tmp4_;
	}
	_tmp5_ = f;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_g_object_unref0 (file);
	file = _tmp6_;
	{
		gsize s = 0UL;
		gchar* data = NULL;
		GFile* _tmp7_;
		GFileOutputStream* _tmp8_ = NULL;
		GFileOutputStream* _tmp9_;
		GKeyFile* _tmp10_;
		gsize _tmp11_ = 0UL;
		gchar* _tmp12_ = NULL;
		GFileOutputStream* _tmp13_;
		const gchar* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		guint8* _tmp16_;
		gint _tmp16__length1;
		_tmp7_ = file;
		_tmp8_ = g_file_replace (_tmp7_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_free0 (data);
			goto __catch28_g_error;
		}
		_g_object_unref0 (fos);
		fos = _tmp9_;
		_tmp10_ = self->keyFile;
		_tmp12_ = g_key_file_to_data (_tmp10_, &_tmp11_, NULL);
		s = _tmp11_;
		_g_free0 (data);
		data = _tmp12_;
		_tmp13_ = fos;
		_tmp14_ = data;
		_tmp15_ = string_get_data (_tmp14_, &_tmp15__length1);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _tmp15__length1;
		g_output_stream_write ((GOutputStream*) _tmp13_, _tmp16_, (gsize) _tmp16__length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (data);
			goto __catch28_g_error;
		}
		_g_free0 (data);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "profile.save error: %s\n", _tmp19_);
		_tmp20_ = default_profile;
		if (!_tmp20_) {
			GtkWindow* _tmp21_;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			GError* _tmp24_;
			const gchar* _tmp25_;
			GtkMessageDialog* _tmp26_;
			GtkMessageDialog* _tmp27_;
			GtkMessageDialog* errorDialog;
			GtkMessageDialog* _tmp28_;
			GtkMessageDialog* _tmp29_;
			_tmp21_ = window;
			_tmp22_ = _ ("Error: Could not open file");
			_tmp23_ = filename;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			_tmp26_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp21_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s: %s\n%s", _tmp22_, _tmp23_, _tmp25_);
			_tmp27_ = g_object_ref_sink (_tmp26_);
			errorDialog = _tmp27_;
			_tmp28_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp28_);
			_tmp29_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp29_);
			_g_object_unref0 (errorDialog);
		}
		_g_error_free0 (e);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_free0 (f);
		_g_object_unref0 (fos);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (f);
	_g_object_unref0 (fos);
	_g_object_unref0 (file);
}


Profile* profile_construct (GType object_type) {
	Profile * self = NULL;
	self = (Profile*) g_object_new (object_type, NULL);
	return self;
}


Profile* profile_new (void) {
	return profile_construct (TYPE_PROFILE);
}


static GObject * profile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Profile * self;
	GKeyFile* _tmp0_;
	parent_class = G_OBJECT_CLASS (profile_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PROFILE (obj);
	_tmp0_ = g_key_file_new ();
	_g_key_file_free0 (self->keyFile);
	self->keyFile = _tmp0_;
	return obj;
}


static void profile_class_init (ProfileClass * klass) {
	profile_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = profile_constructor;
	G_OBJECT_CLASS (klass)->finalize = profile_finalize;
}


static void profile_instance_init (Profile * self) {
}


static void profile_finalize (GObject* obj) {
	Profile * self;
	self = PROFILE (obj);
	_g_key_file_free0 (self->keyFile);
	G_OBJECT_CLASS (profile_parent_class)->finalize (obj);
}


GType profile_get_type (void) {
	static volatile gsize profile_type_id__volatile = 0;
	if (g_once_init_enter (&profile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Profile), 0, (GInstanceInitFunc) profile_instance_init, NULL };
		GType profile_type_id;
		profile_type_id = g_type_register_static (G_TYPE_OBJECT, "Profile", &g_define_type_info, 0);
		g_once_init_leave (&profile_type_id__volatile, profile_type_id);
	}
	return profile_type_id__volatile;
}



