
/*
 * $Header: /cvsroot/mpdist/mpdist/mptool/xutil.c,v 1.2 2002/10/15 19:09:32 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mptool.h"
#include "main.h"
#include "interface.h"
#include "support.h"
#include "mptool.xpm"
#include "printing.xpm"

enum {
  TARGET_STRING,
};

static GdkPixmap *nicon;      /* Normal icon image. */
static GdkPixmap *picon;      /* Printing icon image. */
static GdkBitmap *mask;       /* Mask associated with the two icons. */


void
add_list_item(GtkWidget *list, int index, gchar *label)
{
    GtkWidget *newitem;
    GList *listitems = NULL;

    newitem = gtk_list_item_new_with_label(label);
    gtk_widget_show(newitem);

    listitems = g_list_append(listitems, newitem);
    gtk_list_insert_items(GTK_LIST(list), listitems, index);
}


GdkPixmap *
create_mp_pixmap(gchar **buf)
{
    return(gdk_pixmap_create_from_xpm_d(main_frame_widget->window, &mask, 
                                        NULL, buf));
}


void
delete_list_item(GtkWidget *list, int index)
{
    fprintf(stderr, "delete_list_item: index: %d\n", index);

    gtk_list_clear_items(GTK_LIST(list), index, index+1);
}


void
create_and_set_icons (void)
{
    nicon = create_mp_pixmap(mptool_xpm_bits);
    picon = create_mp_pixmap(printing_xpm_bits);

    set_icon(I_NORMAL);
}


int
get_bool_value (GtkWidget *parent, gchar *label)
{
    GtkWidget *widget = lookup_widget(parent, label);
 
    if (GTK_IS_RADIO_BUTTON(widget) || GTK_IS_CHECK_BUTTON(widget)) {
        return(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
    } else {
        fprintf(stderr, "get_bool_value: label %s: ", label);
        fprintf(stderr, "don't know this widget type: %s\n",
                gtk_type_name(GTK_OBJECT_TYPE(widget)));
        return(0);
    }
}


int
get_int_value (GtkWidget *parent, gchar *label)
{
    GtkWidget *widget = lookup_widget(parent, label);

    if (GTK_IS_SPIN_BUTTON(widget)) {
        return(gtk_spin_button_get_value_as_int((GtkSpinButton *) widget));
    } else if (GTK_IS_ENTRY(widget)) {
        return(atoi(gtk_entry_get_text(GTK_ENTRY(widget))));
    } else {
        fprintf(stderr, "get_int_value: label %s: ", label);
        fprintf(stderr, "don't know this widget type: %s\n",
                gtk_type_name(GTK_OBJECT_TYPE(widget)));
        return(0);
    }
}


char * 
get_str_value (GtkWidget *parent, gchar *label)
{
    GtkWidget *widget = lookup_widget(parent, label);

    if (GTK_IS_ENTRY(widget)) {
        return(gtk_entry_get_text(GTK_ENTRY(widget)));
    } else {
        fprintf(stderr, "get_str_value: label %s: ", label);
        fprintf(stderr, "don't know this widget type: %s\n",
                gtk_type_name(GTK_OBJECT_TYPE(widget)));
        return(" ");
    }   
}


#ifndef NO_DND

static void
filenames_dropped(GtkWidget        *widget,
                  GdkDragContext   *context,
                  gint              x,
                  gint              y,
                  GtkSelectionData *selection_data,
                  guint             info,
                  guint             time)
{
    char err[MAXLINE], filename[MAXLINE];
    FILE *fp;

    if (!selection_data->data) {
        return;
    }

    switch (info) {
        case TARGET_STRING:
            STRCPY(filename, "/tmp/.MptoolXXXXXX");
            MKTEMP(filename);
            if ((fp = fopen(filename, "w")) != NULL) {
                FPUTS(selection_data->data, fp);
                FCLOSE(fp);
                do_print_cmd(filename);
            } else {
                SPRINTF(err, mptool_strs[(int) S_DRAGDROP], filename);
                notice(F_MAIN, err);
            }
            break;
    }
}


void
init_dnd(GtkWidget * widget)
{
    static GtkTargetEntry drag_types[] = {
        { "STRING",     0, TARGET_STRING },
        { "text/plain", 0, TARGET_STRING },
    };
    static gint n_drag_types = sizeof(drag_types) / sizeof(drag_types[0]);

    gtk_drag_dest_set(widget,
                      GTK_DEST_DEFAULT_MOTION |
                      GTK_DEST_DEFAULT_HIGHLIGHT |
                      GTK_DEST_DEFAULT_DROP,
                      drag_types, 
                      n_drag_types,
                      GDK_ACTION_COPY);
 
    gtk_signal_connect(GTK_OBJECT(widget), "drag_data_received",
                       GTK_SIGNAL_FUNC(filenames_dropped), NULL);
}
#endif /* !NO_DND */

int
item_exists (GtkWidget *list, gchar *str)
{
    char *liststr;
    int i, found, nrows;

    found = FALSE;
    nrows = g_list_length(GTK_LIST(list)->children);
    for (i = 0; i < nrows; i++) {
        GtkWidget *listitem = g_list_nth_data(GTK_LIST(list)->children, i);

        gtk_label_get(GTK_LABEL(GTK_BIN(listitem)->child), &liststr);
        if (EQUAL(liststr, str)) {
            found = TRUE;
            break;
        }
    }
    return((found == TRUE) ? i : 0);
}


void
notice (GtkWidget *widget, char *message)
{
    GtkWidget *notice_label;

    if (notice_widget == NULL) {
        notice_widget = create_notice_widget();
    }

    notice_label = lookup_widget(F_NOTICE, "notice_label");
    gtk_label_set_text(GTK_LABEL(notice_label), message);

    gtk_widget_show(notice_widget);
}


void
set_active (GtkWidget *parent, gchar *label, int state)
{
    GtkWidget *widget = lookup_widget(parent, label);

    gtk_widget_set_sensitive(widget, state);
}


void
set_bool_value (GtkWidget *parent, gchar *label, int state)
{
    GtkWidget *widget = lookup_widget(parent, label);
 
    if (GTK_IS_CHECK_BUTTON(widget)) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), state);
    } else {
        fprintf(stderr, "set_bool_value: label %s: ", label);
        fprintf(stderr, "don't know this widget type: %s\n",
                gtk_type_name(GTK_OBJECT_TYPE(widget)));
    }
}


void 
set_excl_value (GtkWidget *parent, gchar *label)
{
    GtkWidget *widget = lookup_widget(parent, label);

    if (GTK_IS_RADIO_MENU_ITEM(widget)) {
        gtk_check_menu_item_set_active((GtkCheckMenuItem *) widget, TRUE);
    } else if (GTK_IS_RADIO_BUTTON(widget)) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), TRUE);
    } else {
        fprintf(stderr, "set_excl_value: label %s: ", label);
        fprintf(stderr, "don't know this widget type: %s\n",
                gtk_type_name(GTK_OBJECT_TYPE(widget)));
    }
}


void
set_help_state(int show_help)
{
    if (show_help) {
        gtk_tooltips_enable(tips);
    } else {
        gtk_tooltips_disable(tips);
    }
}


void
set_icon(enum icon_type itype)
{
    GdkPixmap *icon = (itype == I_NORMAL) ? nicon : picon;

    gdk_window_set_icon(main_frame_widget->window, NULL, icon, mask);
}


void 
set_int_value (GtkWidget *parent, gchar *label, int value)
{
    char str[MAXLINE];
    GtkWidget *widget = lookup_widget(parent, label);

    SPRINTF(str, "%d", value);
    if (GTK_IS_SPIN_BUTTON(widget)) {
        gtk_spin_button_set_value((GtkSpinButton *) widget, (gfloat) value);
    } else if (GTK_IS_ENTRY(widget)) {
        gtk_entry_set_text(GTK_ENTRY(widget), str);
    } else {
        fprintf(stderr, "set_int_value: label %s: ", label);
        fprintf(stderr, "don't know this widget type: %s\n",
                gtk_type_name(GTK_OBJECT_TYPE(widget)));
    }
}


void 
set_str_value (GtkWidget *parent, gchar *label, char *value)
{
    GtkWidget *widget = lookup_widget(parent, label);

    gtk_entry_set_text(GTK_ENTRY(widget), value);
}
