import typing
from typing import ClassVar, overload

PI: float
__version__: str

class Point:
    class AngleUnit:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        degree: ClassVar[Point.AngleUnit] = ...
        radian: ClassVar[Point.AngleUnit] = ...
        def __init__(self, value: typing.SupportsInt) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class LengthUnit:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        inch: ClassVar[Point.LengthUnit] = ...
        mm: ClassVar[Point.LengthUnit] = ...
        pixel: ClassVar[Point.LengthUnit] = ...
        def __init__(self, value: typing.SupportsInt) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    angle_unit: ClassVar[Point.AngleUnit] = ...
    length_unit: ClassVar[Point.LengthUnit] = ...
    x_axis: ClassVar[Point] = ...  # read-only
    y_axis: ClassVar[Point] = ...  # read-only
    origin: ClassVar[Point] = ...
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: typing.SupportsFloat, y: typing.SupportsFloat) -> None: ...
    def as_list(self) -> list[float]: ...
    @overload
    def distance_to(self, x: typing.SupportsFloat, y: typing.SupportsFloat) -> float: ...
    @overload
    def distance_to(self, other: Point) -> float: ...
    @property
    def length(self) -> float: ...

def answer() -> int: ...
def midpoint(left: typing.SupportsFloat, right: typing.SupportsFloat) -> float: ...
def sum(arg0: typing.SupportsInt, arg1: typing.SupportsInt) -> int: ...
def weighted_midpoint(left: typing.SupportsFloat, right: typing.SupportsFloat, alpha: typing.SupportsFloat = ...) -> float: ...
