/**
 * Navit, a modular navigation system.
 * Copyright (C) 2005-2008 Navit Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#ifndef NAVIT_TYPES_H
#define NAVIT_TYPES_H
#include <stdint.h>

typedef int8_t s8;
typedef uint8_t u8;
typedef int16_t s16;
typedef uint16_t u16;
typedef int32_t s32;
typedef uint32_t u32;

#ifdef HAVE_API_WIN32_BASE
#define ULONGLONG_FMT "%I64u"
#define LONGLONG_FMT "%I64d"
#define LONGLONG_HEX_FMT "%I64x"
#else
#define ULONGLONG_FMT "%llu"
#define LONGLONG_FMT "%lld"
#define LONGLONG_HEX_FMT "%llx"
#endif


#endif
