/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.php.project.connections.sftp;

import javax.swing.GroupLayout.Alignment;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 * @author Tomas Mysik
 */
public class MessagePanel extends JPanel {
    private static final long serialVersionUID = 3118448431190412984L;

    public MessagePanel(String message) {
        assert StringUtils.hasText(message);

        initComponents();
        // #169115 - is there a better way?
        messageLabel.setText("<html>" + message.replaceAll("(\r?\n|\r)", "<br />")); // NOI18N
    }

    public boolean doNotShowThisMessageAgain() {
        return doNotShowAgainCheckBox.isSelected();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        messageLabel = new JLabel();
        doNotShowAgainCheckBox = new JCheckBox();

        setFocusTraversalPolicy(null);

        messageLabel.setLabelFor(this);
        Mnemonics.setLocalizedText(messageLabel, "DUMMY"); // NOI18N

        doNotShowAgainCheckBox.setSelected(true);

        Mnemonics.setLocalizedText(doNotShowAgainCheckBox, NbBundle.getMessage(MessagePanel.class, "MessagePanel.doNotShowAgainCheckBox.text"));
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);

        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addComponent(doNotShowAgainCheckBox)
                    .addComponent(messageLabel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(messageLabel)
                .addGap(18, 18, 18)
                .addComponent(doNotShowAgainCheckBox)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        messageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MessagePanel.class, "MessagePanel.messageLabel.AccessibleContext.accessibleName")); // NOI18N
        messageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessagePanel.class, "MessagePanel.messageLabel.AccessibleContext.accessibleDescription")); // NOI18N
        doNotShowAgainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MessagePanel.class, "MessagePanel.doNotShowAgainCheckBox.AccessibleContext.accessibleName")); // NOI18N
        doNotShowAgainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessagePanel.class, "MessagePanel.doNotShowAgainCheckBox.AccessibleContext.accessibleDescription")); // NOI18N
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MessagePanel.class, "MessagePanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JCheckBox doNotShowAgainCheckBox;
    private JLabel messageLabel;
    // End of variables declaration//GEN-END:variables

}
