/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLCharacterMap
extends StyleElement {
    String use;
    List characterMapElements = null;
    boolean validated = false;
    boolean redundant = false;

    public StructuredQName getCharacterMapName() {
        StructuredQName name = this.getObjectName();
        if (name == null) {
            try {
                return this.makeQName(this.getAttributeValue("", "name"));
            }
            catch (Exception err) {
                return new StructuredQName("", "", "unnamedCharacterMap_" + this.hashCode());
            }
        }
        return name;
    }

    public boolean isRedundant() {
        return this.redundant;
    }

    public void prepareAttributes() throws XPathException {
        String name = null;
        this.use = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                name = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-character-maps")) {
                this.use = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (name == null) {
            this.reportAbsence("name");
            name = "unnamedCharacterMap_" + this.hashCode();
        }
        try {
            this.setObjectName(this.makeQName(name));
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
            name = "unnamedCharacterMap_" + this.hashCode();
            this.setObjectName(new StructuredQName("", "", name));
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), "XTSE0020");
            name = "unnamedCharacterMap_" + this.hashCode();
            this.setObjectName(new StructuredQName("", "", name));
        }
    }

    public void validate() throws XPathException {
        Item child;
        if (this.validated) {
            return;
        }
        this.checkTopLevel(null);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLOutputCharacter) continue;
            this.compileError("Only xsl:output-character is allowed within xsl:character-map", "XTSE0010");
        }
        XSLStylesheet principal = this.getPrincipalStylesheet();
        XSLCharacterMap other = principal.getCharacterMap(this.getObjectName());
        if (other != this) {
            if (this.getPrecedence() == other.getPrecedence()) {
                this.compileError("There are two character-maps with the same name and import precedence", "XTSE1580");
            } else if (this.getPrecedence() < other.getPrecedence()) {
                this.redundant = true;
            }
        }
        if (this.use != null) {
            this.characterMapElements = new ArrayList(5);
            StringTokenizer st = new StringTokenizer(this.use, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String displayname = st.nextToken();
                try {
                    StructuredQName qn;
                    XSLCharacterMap ref;
                    String[] parts = this.getConfiguration().getNameChecker().getQNameParts(displayname);
                    String uri = this.getURIForPrefix(parts[0], false);
                    if (uri == null) {
                        this.compileError("Undeclared namespace prefix " + Err.wrap(parts[0]) + " in character map name", "XTSE0280");
                    }
                    if ((ref = principal.getCharacterMap(qn = new StructuredQName(parts[0], uri, parts[1]))) == null) {
                        this.compileError("No character-map named '" + displayname + "' has been defined", "XTSE1590");
                        continue;
                    }
                    this.characterMapElements.add(ref);
                }
                catch (QNameException err) {
                    this.compileError("Invalid character-map name. " + err.getMessage(), "XTSE1590");
                }
            }
            Iterator it = this.characterMapElements.iterator();
            while (it.hasNext()) {
                ((XSLCharacterMap)it.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    private void checkCircularity(XSLCharacterMap origin) throws XPathException {
        if (this == origin) {
            this.compileError("The definition of the character map is circular", "XTSE1600");
            this.characterMapElements = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.characterMapElements != null) {
                Iterator it = this.characterMapElements.iterator();
                while (it.hasNext()) {
                    ((XSLCharacterMap)it.next()).checkCircularity(origin);
                }
            }
        }
    }

    public void assemble(IntHashMap map) {
        if (this.characterMapElements != null) {
            for (int i = 0; i < this.characterMapElements.size(); ++i) {
                XSLCharacterMap charmap = (XSLCharacterMap)this.characterMapElements.get(i);
                charmap.assemble(map);
            }
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        Item child;
        while ((child = kids.next()) != null) {
            XSLOutputCharacter oc = (XSLOutputCharacter)child;
            map.put(oc.getCodePoint(), oc.getReplacementString());
        }
        return;
    }

    public Expression compile(Executable exec) throws XPathException {
        return null;
    }
}

