/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.Iterator;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceCodeIterator;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeImpl;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.TextImpl;
import net.sf.saxon.value.Whitespace;

public class ElementImpl
extends ParentNodeImpl
implements NamespaceResolver {
    protected int nameCode;
    protected int typeCode;
    protected AttributeCollection attributeList;
    protected int[] namespaceList = null;

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public void initialise(int nameCode, int typeCode, AttributeCollectionImpl atts, NodeInfo parent, int sequenceNumber) {
        this.nameCode = nameCode;
        this.typeCode = typeCode == -1 ? 630 : typeCode;
        this.parent = (ParentNodeImpl)parent;
        this.sequence = sequenceNumber;
        this.attributeList = atts;
    }

    public void setLocation(String systemId, int line, int column) {
        DocumentImpl root = this.parent.getPhysicalRoot();
        root.setLineAndColumn(this.sequence, line, column);
        root.setSystemId(this.sequence, systemId);
    }

    public void setSystemId(String uri) {
        this.getPhysicalRoot().setSystemId(this.sequence, uri);
    }

    public NodeInfo getRoot() {
        ParentNodeImpl up = this.parent;
        if (up == null || up instanceof DocumentImpl && ((DocumentImpl)up).isImaginary()) {
            return this;
        }
        return up.getRoot();
    }

    public DocumentInfo getDocumentRoot() {
        NodeInfo root = this.getRoot();
        if (root instanceof DocumentInfo) {
            return (DocumentInfo)root;
        }
        return null;
    }

    public final String getSystemId() {
        DocumentImpl root = this.getPhysicalRoot();
        return root == null ? null : root.getSystemId(this.sequence);
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public boolean isNilled() {
        return (this.typeCode & 0x20000000) != 0;
    }

    public void setTypeAnnotation(int typeCode) {
        if (typeCode == -1) {
            typeCode = 630;
        }
        this.typeCode = typeCode;
    }

    public int getTypeAnnotation() {
        return this.typeCode & 0xFFFFF;
    }

    public void setLineAndColumn(int line, int column) {
        DocumentImpl root = this.getPhysicalRoot();
        if (root != null) {
            root.setLineAndColumn(this.sequence, line, column);
        }
    }

    public int getLineNumber() {
        DocumentImpl root = this.getPhysicalRoot();
        if (root == null) {
            return -1;
        }
        return root.getLineNumber(this.sequence);
    }

    public int getColumnNumber() {
        DocumentImpl root = this.getPhysicalRoot();
        if (root == null) {
            return -1;
        }
        return root.getColumnNumber(this.sequence);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void generateId(FastStringBuffer buffer) {
        if (this.sequence >= 0) {
            this.getPhysicalRoot().generateId(buffer);
            buffer.append("e");
            buffer.append(Integer.toString(this.sequence));
        } else {
            this.parent.generateId(buffer);
            buffer.append("f");
            buffer.append(Integer.toString(this.index));
        }
    }

    public final int getNodeKind() {
        return 1;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        int typeCode = copyAnnotations ? this.getTypeAnnotation() : 630;
        CopyInformee informee = out.getPipelineConfiguration().getCopyInformee();
        if (informee != null) {
            locationId = informee.notifyElementNode(this);
        }
        out.startElement(this.getNameCode(), typeCode, locationId, 0);
        switch (whichNamespaces) {
            case 0: {
                break;
            }
            case 1: {
                int ns;
                int[] localNamespaces = this.getDeclaredNamespaces(null);
                for (int i = 0; i < localNamespaces.length && (ns = localNamespaces[i]) != -1; ++i) {
                    out.namespace(ns, 0);
                }
                break;
            }
            case 2: {
                NamespaceCodeIterator.sendNamespaces(this, out);
            }
        }
        if (this.attributeList != null) {
            for (int i = 0; i < this.attributeList.getLength(); ++i) {
                int nc = this.attributeList.getNameCode(i);
                if (nc == -1) continue;
                out.attribute(nc, 631, this.attributeList.getValue(i), 0, 0);
            }
        }
        out.startContent();
        int childNamespaces = whichNamespaces == 0 ? 0 : 1;
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            next.copy(out, childNamespaces, copyAnnotations, locationId);
        }
        out.endElement();
    }

    public void delete() {
        DocumentImpl root = this.getPhysicalRoot();
        super.delete();
        if (root != null) {
            AxisIterator iter = this.iterateAxis((byte)5, NodeKindTest.ELEMENT);
            while (true) {
                ElementImpl n = (ElementImpl)iter.next();
                int atts = this.attributeList.getLength();
                for (int index = 0; index < atts; ++index) {
                    if (!this.attributeList.isId(index)) continue;
                    root.deregisterID(this.attributeList.getValue(index));
                }
                if (n == null) break;
                root.deIndex(n);
            }
        }
    }

    public void rename(int newNameCode) {
        this.nameCode = newNameCode;
        int nscode = this.getNamePool().getNamespaceCode(newNameCode);
        int prefixCode = nscode >> 16 & 0xFFFF;
        short uc = this.getURICodeForPrefixCode(prefixCode);
        if (uc == -1) {
            this.addNamespace(nscode, false);
        } else if (uc != (nscode & 0xFFFF)) {
            throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
        }
    }

    public void addNamespace(int nscode, boolean inherit) {
        if ((nscode & 0xFFFF) == 0) {
            throw new IllegalArgumentException("Cannot add a namespace undeclaration");
        }
        this.addNamespaceInternal(nscode, true);
        if (this.hasChildNodes() && !inherit) {
            ElementImpl child;
            int undecl = nscode & 0xFFFF0000;
            AxisIterator kids = this.enumerateChildren(NodeKindTest.ELEMENT);
            while ((child = (ElementImpl)kids.next()) != null) {
                child.addNamespaceInternal(undecl, false);
            }
        }
    }

    private void addNamespaceInternal(int nscode, boolean externalCall) {
        if (this.namespaceList == null) {
            this.namespaceList = new int[]{nscode};
        } else {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if (this.namespaceList[i] == nscode) {
                    return;
                }
                if ((this.namespaceList[i] & 0xFFFF0000) != (nscode & 0xFFFF0000)) continue;
                if ((this.namespaceList[i] & 0xFFFF) == 0) {
                    this.namespaceList[i] = nscode;
                    continue;
                }
                if (externalCall) {
                    throw new IllegalArgumentException("New namespace conflicts with existing namespace binding");
                }
                return;
            }
            int len = this.namespaceList.length;
            int[] ns2 = new int[len + 1];
            System.arraycopy(this.namespaceList, 0, ns2, 0, len);
            ns2[len] = nscode;
            this.namespaceList = ns2;
        }
    }

    public void replaceStringValue(CharSequence stringValue) {
        this.children = stringValue.length() == 0 ? null : new TextImpl(this, ((Object)stringValue).toString());
    }

    public void addAttribute(int nameCode, int typeCode, CharSequence value, int properties) {
        DocumentImpl root;
        AttributeCollectionImpl atts;
        int index;
        if (this.attributeList == null || this.attributeList.getLength() == 0) {
            this.attributeList = new AttributeCollectionImpl(this.getConfiguration());
        }
        if ((index = (atts = (AttributeCollectionImpl)this.attributeList).getIndexByFingerprint(nameCode & 0xFFFFF)) != -1) {
            throw new IllegalStateException("Cannot add an attribute to an element as it already has an attribute with the specified name");
        }
        atts.addAttribute(nameCode, typeCode, ((Object)value).toString(), 0L, 0);
        if ((properties & 0x800) != 0 && (root = this.getPhysicalRoot()) != null) {
            root.registerID(this, Whitespace.trim(value));
        }
    }

    public void removeAttribute(NodeInfo attribute) {
        if (!(attribute instanceof AttributeImpl)) {
            return;
        }
        AttributeCollectionImpl atts = (AttributeCollectionImpl)this.getAttributeList();
        int index = ((AttributeImpl)attribute).index;
        if (index >= 0 && atts.isId(index)) {
            DocumentImpl root = this.getPhysicalRoot();
            root.deregisterID(atts.getValue(index));
        }
        atts.removeAttribute(index);
        ((AttributeImpl)attribute).parent = null;
    }

    public void removeTypeAnnotation() {
        int t = this.getTypeAnnotation();
        if (t != 630) {
            this.typeCode = 572;
            this.parent.removeTypeAnnotation();
        }
    }

    public void setNamespaceDeclarations(int[] namespaces, int namespacesUsed) {
        this.namespaceList = new int[namespacesUsed];
        System.arraycopy(namespaces, 0, this.namespaceList, 0, namespacesUsed);
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.length() == 0 && !useDefault) {
            return "";
        }
        NamePool pool = this.getNamePool();
        short prefixCode = pool.getCodeForPrefix(prefix);
        if (prefixCode == -1) {
            return null;
        }
        short uriCode = this.getURICodeForPrefixCode(prefixCode);
        if (uriCode == -1) {
            return null;
        }
        return pool.getURIFromURICode(uriCode);
    }

    public Iterator iteratePrefixes() {
        return new Iterator(){
            private NamePool pool = null;
            private IntIterator iter = NamespaceCodeIterator.iterateNamespaces(ElementImpl.this);

            public boolean hasNext() {
                return this.pool == null || this.iter.hasNext();
            }

            public Object next() {
                if (this.pool == null) {
                    this.pool = ElementImpl.this.getNamePool();
                    return "xml";
                }
                return this.pool.getPrefixFromNamespaceCode(this.iter.next());
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public short getURICodeForPrefix(String prefix) throws NamespaceException {
        if (prefix.equals("xml")) {
            return 1;
        }
        NamePool pool = this.getNamePool();
        short prefixCode = pool.getCodeForPrefix(prefix);
        if (prefixCode == -1) {
            throw new NamespaceException(prefix);
        }
        short uc = this.getURICodeForPrefixCode(prefixCode);
        if (uc == -1) {
            throw new NamespaceException(this.getNamePool().getPrefixFromNamespaceCode(prefixCode << 16));
        }
        return uc;
    }

    protected short getURICodeForPrefixCode(int prefixCode) {
        ParentNodeImpl next;
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if (this.namespaceList[i] >> 16 != prefixCode) continue;
                int u = this.namespaceList[i] & 0xFFFF;
                return (short)(u == 0 && prefixCode != 0 ? -1 : u);
            }
        }
        if ((next = this.parent).getNodeKind() == 9) {
            if (prefixCode == 0) {
                return 0;
            }
            return -1;
        }
        return ((ElementImpl)next).getURICodeForPrefixCode(prefixCode);
    }

    public String getPrefixForURI(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        NamePool pool = this.getNamePool();
        short uriCode = pool.getCodeForURI(uri);
        if (uriCode < 0) {
            return null;
        }
        return this.getPrefixForURICode(uriCode);
    }

    private String getPrefixForURICode(int code) {
        ParentNodeImpl next;
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                if ((this.namespaceList[i] & 0xFFFF) != code) continue;
                return this.getNamePool().getPrefixFromNamespaceCode(this.namespaceList[i]);
            }
        }
        if ((next = this.parent) instanceof DocumentInfo) {
            return null;
        }
        return ((ElementImpl)next).getPrefixForURICode(code);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return this.namespaceList == null ? IntArraySet.EMPTY_INT_ARRAY : this.namespaceList;
    }

    public int[] getInScopeNamespaceCodes() {
        return NamespaceIterator.getInScopeNamespaceCodes(this);
    }

    protected void fixupInsertedNamespaces(boolean inherit) {
        if (this.parent.getNodeKind() == 9) {
            return;
        }
        IntHashSet childNamespaces = new IntHashSet();
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                childNamespaces.add(this.namespaceList[i]);
            }
        }
        InscopeNamespaceResolver inscope = new InscopeNamespaceResolver(this.parent);
        NamePool pool = this.getNamePool();
        if (this.getURI().length() == 0 && inscope.getURIForPrefix("", true).length() != 0) {
            childNamespaces.add(0);
        }
        if (!inherit) {
            Iterator<String> it = inscope.iteratePrefixes();
            while (it.hasNext()) {
                String prefix = it.next();
                int prefixCode = pool.getCodeForPrefix(prefix) << 16;
                boolean found = false;
                if (this.namespaceList != null) {
                    for (int i = 0; i < this.namespaceList.length; ++i) {
                        if ((this.namespaceList[i] & 0xFFFF) != prefixCode) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                childNamespaces.add(prefixCode);
            }
        }
        if (this.namespaceList != null) {
            for (int i = 0; i < this.namespaceList.length; ++i) {
                int nscode = this.namespaceList[i];
                String prefix = pool.getPrefixFromNamespaceCode(nscode);
                String uri = pool.getURIFromNamespaceCode(nscode);
                String parentUri = inscope.getURIForPrefix(prefix, true);
                if (parentUri == null || !parentUri.equals(uri)) continue;
                childNamespaces.remove(nscode);
            }
        }
        int[] n2 = new int[childNamespaces.size()];
        int j = 0;
        IntIterator ii = childNamespaces.iterator();
        while (ii.hasNext()) {
            n2[j++] = ii.next();
        }
        this.namespaceList = n2;
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList == null ? AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION : this.attributeList;
    }

    public String getAttributeValue(int fingerprint) {
        return this.attributeList == null ? null : this.attributeList.getValueByFingerprint(fingerprint);
    }

    public String getAttributeValue(String uri, String localName) {
        return this.attributeList == null ? null : this.attributeList.getValue(uri, localName);
    }

    public boolean isId() {
        int tc = this.getTypeAnnotation();
        if (tc < 1024) {
            return tc == 560;
        }
        return this.getConfiguration().getTypeHierarchy().isIdCode(tc);
    }
}

