---
id: fast-foundation.elementdefinitioncontext
title: ElementDefinitionContext interface
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [ElementDefinitionContext](./fast-foundation.elementdefinitioncontext.md)

## ElementDefinitionContext interface

The design system context in which an element can be defined.

<b>Signature:</b>

```typescript
export interface ElementDefinitionContext 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [container](./fast-foundation.elementdefinitioncontext.container.md) | [Container](./fast-foundation.container.md) | The dependency injection container associated with the design system. |
|  [name](./fast-foundation.elementdefinitioncontext.name.md) | string | The name that the element will be defined as. |
|  [shadowRootMode](./fast-foundation.elementdefinitioncontext.shadowrootmode.md) | ShadowRootMode \| undefined | The shadow root mode specified by the design system's configuration. |
|  [type](./fast-foundation.elementdefinitioncontext.type.md) | [Constructable](./fast-element.constructable.md) | The type that will be defined. |
|  [willDefine](./fast-foundation.elementdefinitioncontext.willdefine.md) | boolean | Indicates whether or not a platform define call will be made in order to define the element. |

## Methods

|  Method | Description |
|  --- | --- |
|  [defineElement(definition)](./fast-foundation.elementdefinitioncontext.defineelement.md) | Defines the element. |
|  [definePresentation(presentation)](./fast-foundation.elementdefinitioncontext.definepresentation.md) | Defines a presentation for the element. |
|  [tagFor(type)](./fast-foundation.elementdefinitioncontext.tagfor.md) | Returns the HTML element tag name that the type will be defined as. |
