<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Tracing](./puppeteer.tracing.md)

## Tracing class

The Tracing class exposes the tracing audit interface.

<b>Signature:</b>

```typescript
export declare class Tracing 
```

## Remarks

You can use `tracing.start` and `tracing.stop` to create a trace file which can be opened in Chrome DevTools or [timeline viewer](https://chromedevtools.github.io/timeline-viewer/).

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `Tracing` class.

## Example


```js
await page.tracing.start({path: 'trace.json'});
await page.goto('https://www.google.com');
await page.tracing.stop();

```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [\_client](./puppeteer.tracing._client.md) |  | [CDPSession](./puppeteer.cdpsession.md) |  |
|  [\_path](./puppeteer.tracing._path.md) |  | string |  |
|  [\_recording](./puppeteer.tracing._recording.md) |  | boolean |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [start(options)](./puppeteer.tracing.start.md) |  | Starts a trace for the current page. |
|  [stop()](./puppeteer.tracing.stop.md) |  | Stops a trace started with the <code>start</code> method. |

