/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var hasIteratorSymbolSupport = require( '@stdlib/assert/has-iterator-symbol-support' );


// MAIN //

/**
* Iterator symbol.
*
* @name IteratorSymbol
* @constant
* @type {(symbol|null)}
*
* @example
* function iterator() {
*     var it;
*     var i;
*
*     i = -1;
*
*     it = {};
*     it.next = next;
*     it.return = done;
*
*     if ( IteratorSymbol ) {
*         it[ IteratorSymbol ] = iterator;
*     }
*     return it;
*
*     function next() {
*         i += 1;
*         return {
*             'value': i,
*             'done': false
*         };
*     }
*
*     function done( value ) {
*         if ( arguments.length === 0 ) {
*             return {
*                 'done': true
*             };
*         }
*         return {
*             'value': value,
*             'done': true
*         };
*     }
* }
*
* var obj = iterator();
*/
var IteratorSymbol = ( hasIteratorSymbolSupport() ) ? Symbol.iterator : null;


// EXPORTS //

module.exports = IteratorSymbol;
