/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.webmacro;

import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.turbine.util.ObjectUtils;
import org.webmacro.Context;

public class WebMacroFormatter {
    Context context = null;
    NumberFormat nf = NumberFormat.getInstance();

    public String formatShortDate(Date date) {
        return DateFormat.getDateInstance(3).format(date);
    }

    public String formatLongDate(Date date) {
        return DateFormat.getDateInstance(1).format(date);
    }

    public String formatShortDateTime(Date date) {
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }

    public String formatLongDateTime(Date date) {
        return DateFormat.getDateTimeInstance(1, 1).format(date);
    }

    public String formatArray(Object array) {
        return this.formatArray(array, ", ", " and ");
    }

    public String formatArray(Object array, String delim) {
        return this.formatArray(array, delim, delim);
    }

    public String formatArray(Object array, String delim, String finaldelim) {
        StringBuffer sb = new StringBuffer();
        int arrayLen = Array.getLength(array);
        int i = 0;
        while (i < arrayLen) {
            sb.append(Array.get(array, i).toString());
            if (i < arrayLen - 2) {
                sb.append(delim);
            } else if (i < arrayLen - 1) {
                sb.append(finaldelim);
            }
            ++i;
        }
        return sb.toString();
    }

    public String formatVector(Vector vector) {
        return this.formatVector(vector, ", ", " and ");
    }

    public String formatVector(Vector vector, String delim) {
        return this.formatVector(vector, delim, delim);
    }

    public String formatVector(Vector vector, String delim, String finaldelim) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < vector.size()) {
            sb.append(vector.elementAt(i).toString());
            if (i < vector.size() - 2) {
                sb.append(delim);
            } else if (i < vector.size() - 1) {
                sb.append(finaldelim);
            }
            ++i;
        }
        return sb.toString();
    }

    public String limitLen(int maxlen, String string) {
        return this.limitLen(maxlen, string, "...");
    }

    public String limitLen(int maxlen, String string, String suffix) {
        String ret = string;
        if (string.length() > maxlen) {
            ret = string.substring(0, maxlen - suffix.length()) + suffix;
        }
        return ret;
    }

    public String makeAlternator(String name, String alt1, String alt2) {
        String[] alternates = new String[]{alt1, alt2};
        WebMacroFormatter webMacroFormatter = this;
        if (webMacroFormatter == null) {
            throw null;
        }
        this.context.put((Object)name, (Object)webMacroFormatter.new WebMacroAlternator(alternates));
        return "";
    }

    public String makeAlternator(String name, String alt1, String alt2, String alt3) {
        String[] alternates = new String[]{alt1, alt2, alt3};
        WebMacroFormatter webMacroFormatter = this;
        if (webMacroFormatter == null) {
            throw null;
        }
        this.context.put((Object)name, (Object)webMacroFormatter.new WebMacroAlternator(alternates));
        return "";
    }

    String makeAlternator(String name, String alt1, String alt2, String alt3, String alt4) {
        String[] alternates = new String[]{alt1, alt2, alt3, alt4};
        WebMacroFormatter webMacroFormatter = this;
        if (webMacroFormatter == null) {
            throw null;
        }
        this.context.put((Object)name, (Object)webMacroFormatter.new WebMacroAlternator(alternates));
        return "";
    }

    public Object isNull(Object o, Object dflt) {
        return ObjectUtils.isNull(o, dflt);
    }

    public WebMacroFormatter(Context context) {
        this.context = context;
    }

    public class WebMacroAlternator {
        String[] alternates = null;
        int current = 0;

        public String alternate() {
            ++this.current;
            this.current %= this.alternates.length;
            return "";
        }

        public String toString() {
            return this.alternates[this.current];
        }

        public WebMacroAlternator(String[] alternates) {
            this.alternates = alternates;
        }
    }
}

