/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.convert.AssignmentContextConverter;
import org.chefproject.core.Assignment;
import org.chefproject.core.AssignmentContent;
import org.chefproject.core.AssignmentContentEdit;
import org.chefproject.core.AssignmentEdit;
import org.chefproject.core.AssignmentSubmission;
import org.chefproject.core.AssignmentSubmissionEdit;
import org.chefproject.service.component.BaseAssignmentService;
import org.chefproject.service.component.BaseDbSingleStorage;

public class DbCachedAssignmentService
extends BaseAssignmentService {
    protected String m_assignmentsTableName = "ASSIGNMENT_ASSIGNMENT";
    protected String m_contentsTableName = "ASSIGNMENT_CONTENT";
    protected String m_submissionsTableName = "ASSIGNMENT_SUBMISSION";
    protected boolean m_locksInDb = true;

    public void init(RunData data) throws InitializationException {
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        this.m_assignmentsTableName = this.getProperties().getProperty("assignmentTable", this.m_assignmentsTableName);
        this.m_contentsTableName = this.getProperties().getProperty("assignmentContentTable", this.m_contentsTableName);
        this.m_submissionsTableName = this.getProperties().getProperty("assignmentSubmissionTable", this.m_submissionsTableName);
        super.init(data);
        Log.info("chef", this + ".init(rundata): assignments table: " + this.m_assignmentsTableName + " contents table: " + this.m_contentsTableName + " submissions table: " + this.m_submissionsTableName);
    }

    public void init() throws InitializationException {
        boolean contextConversion = new Boolean(this.getProperties().getProperty("contextConversion", "false"));
        super.init();
        if (contextConversion) {
            AssignmentContextConverter.convert();
        }
        Log.info("chef", this + ".init()");
    }

    protected BaseAssignmentService.AssignmentStorage newAssignmentStorage() {
        return new DbCachedAssignmentStorage(new BaseAssignmentService.AssignmentStorageUser());
    }

    protected BaseAssignmentService.AssignmentContentStorage newContentStorage() {
        return new DbCachedAssignmentContentStorage(new BaseAssignmentService.AssignmentContentStorageUser());
    }

    protected BaseAssignmentService.AssignmentSubmissionStorage newSubmissionStorage() {
        return new DbCachedAssignmentSubmissionStorage(new BaseAssignmentService.AssignmentSubmissionStorageUser());
    }

    protected class DbCachedAssignmentSubmissionStorage
    extends BaseDbSingleStorage
    implements BaseAssignmentService.AssignmentSubmissionStorage {
        public DbCachedAssignmentSubmissionStorage(BaseAssignmentService.AssignmentSubmissionStorageUser submission) {
            super(DbCachedAssignmentService.this.m_submissionsTableName, "SUBMISSION_ID", null, DbCachedAssignmentService.this.m_locksInDb, "submission", submission);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public AssignmentSubmission get(String id) {
            return (AssignmentSubmission)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public AssignmentSubmissionEdit put(String id, String context, String assignmentId) {
            Object[] others = new Object[]{context, assignmentId};
            return (AssignmentSubmissionEdit)super.putResource(id, others);
        }

        public AssignmentSubmissionEdit edit(String id) {
            return (AssignmentSubmissionEdit)super.editResource(id);
        }

        public void commit(AssignmentSubmissionEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(AssignmentSubmissionEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(AssignmentSubmissionEdit edit) {
            super.removeResource(edit);
        }
    }

    protected class DbCachedAssignmentContentStorage
    extends BaseDbSingleStorage
    implements BaseAssignmentService.AssignmentContentStorage {
        public DbCachedAssignmentContentStorage(BaseAssignmentService.AssignmentContentStorageUser content) {
            super(DbCachedAssignmentService.this.m_contentsTableName, "CONTENT_ID", null, DbCachedAssignmentService.this.m_locksInDb, "content", content);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public AssignmentContent get(String id) {
            return (AssignmentContent)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public AssignmentContentEdit put(String id, String context) {
            Object[] others = new Object[]{context};
            return (AssignmentContentEdit)super.putResource(id, others);
        }

        public AssignmentContentEdit edit(String id) {
            return (AssignmentContentEdit)super.editResource(id);
        }

        public void commit(AssignmentContentEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(AssignmentContentEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(AssignmentContentEdit edit) {
            super.removeResource(edit);
        }
    }

    protected class DbCachedAssignmentStorage
    extends BaseDbSingleStorage
    implements BaseAssignmentService.AssignmentStorage {
        public DbCachedAssignmentStorage(BaseAssignmentService.AssignmentStorageUser assignment) {
            super(DbCachedAssignmentService.this.m_assignmentsTableName, "ASSIGNMENT_ID", null, DbCachedAssignmentService.this.m_locksInDb, "assignment", assignment);
        }

        public boolean check(String id) {
            return super.checkResource(id);
        }

        public Assignment get(String id) {
            return (Assignment)super.getResource(id);
        }

        public List getAll() {
            return super.getAllResources();
        }

        public AssignmentEdit put(String id, String context) {
            Object[] others = new Object[]{context};
            return (AssignmentEdit)super.putResource(id, others);
        }

        public AssignmentEdit edit(String id) {
            return (AssignmentEdit)super.editResource(id);
        }

        public void commit(AssignmentEdit edit) {
            super.commitResource(edit);
        }

        public void cancel(AssignmentEdit edit) {
            super.cancelResource(edit);
        }

        public void remove(AssignmentEdit edit) {
            super.removeResource(edit);
        }
    }
}

