PROGRAM gen_error
!
!****	gen_error 
!
!	Purpose:
!	--------
!	This program compares an interpolated field with the initial
!       field mapped to the target grid
!       
!***	History:
!       -------
!       Version   Programmer      Date        Description
!       -------   ----------      ----        -----------
!         1.0   Damien Declat  2002/07/30     Creation
!*----------------------------------------------------------------
!
!** + Declarations
!
!
!** ++ modules and includes
!
!
  IMPLICIT NONE
  INCLUDE 'netcdf.inc'

!
!** ++ Variables
!
  INTEGER :: ib_i, ib_j, ib_ibis, ib_jbis, il_count, il_translate, il_log
!
!** +++ Grid dimensions
!
  INTEGER, DIMENSION(2) :: iga_fld_dim

  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_i
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_j

  INTEGER, PARAMETER :: ig_io = 182
  INTEGER, PARAMETER :: ig_jo = 149
  INTEGER, PARAMETER :: ig_ia = 128
  INTEGER, PARAMETER :: ig_ja = 64
  INTEGER, PARAMETER :: ig_ib = 6232
  INTEGER, PARAMETER :: ig_jb = 1
  INTEGER, PARAMETER :: ig_iz = 96
  INTEGER, PARAMETER :: ig_jz = 72
!
!** +++ Fields
!
  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: rga_interpol_lat
  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: rga_analytic_lat

  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: rga_interpol_lon
  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: rga_analytic_lon

  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: rga_interpol
  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: rga_analytic
  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: rga_errorfld
!
!** +++ Files variables
!
  CHARACTER(LEN=8) :: cg_add
  CHARACTER(LEN=8) :: cg_file_int, cg_file_ana
  CHARACTER(LEN=8) :: cg_file_int_bis, cg_file_ana_bis
  CHARACTER(LEN=8) :: cg_fld_name
  CHARACTER(LEN=8) :: cg_fld_name_lat
  CHARACTER(LEN=8) :: cg_fld_name_lon
!
!** +++ Netcdf variables
!
  INTEGER :: ig_index_remap, ig_index_grid

  INTEGER, DIMENSION(4) :: iga_fld_start  ! array that gives the 
! beginning of the array
  INTEGER, DIMENSION(4) :: iga_fld_count  ! array that gives the 
! dimension of the array
  INTEGER :: ig_status

  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_interp_id
       ! id of the interpolated field
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_analyt_id
       ! id of the analytic field on the tgt grid
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_error_id
       ! id of the error field
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_interp_lat_id
       ! id of the interpolated field
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_analyt_lat_id
       ! id of the analytic field on the tgt grid
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_interp_lon_id
       ! id of the interpolated field
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_analyt_lon_id
       ! id of the analytic field on the tgt grid
  INTEGER, DIMENSION(:), ALLOCATABLE :: ig_i_id, ig_j_id   
       ! dimensions id
  INTEGER, DIMENSION(:,:), ALLOCATABLE :: iga_mask
       ! mask array

  INTEGER :: ig_file_id         ! file id
  INTEGER :: ig_file_grid       ! grid file id
  INTEGER :: ig_msk_id          ! mask array id
  INTEGER :: ig_file_int_id     ! id of the input interpolated files
  INTEGER :: ig_file_ana_id     ! id of the input analytic files
  INTEGER :: ig_fld_id          ! id of the field
!
!** +++ Namelist
!
  INTEGER :: il_unit

  INTEGER :: orca, at42, bt42, lmdz
  INTEGER :: nb_fields, nb_methods, nb_couples, nb_grids
  INTEGER :: dist, gaus, bili, bicu, cons_none, cons_dest, cons_frac
  INTEGER :: at42_orca, bt42_orca, orca_at42, orca_bt42, bt42_at42
   INTEGER :: orca_lmdz, lmdz_orca 
  NAMELIST / par_in / orca, at42, bt42, lmdz, &
     nb_fields, &
     dist, gaus, bili, bicu, cons_none, cons_dest, cons_frac, &
     at42_orca, bt42_orca, orca_at42, orca_bt42, bt42_at42, &
     orca_lmdz, lmdz_orca 
!
!** ++ Loops
!
  INTEGER :: ib_grids
  INTEGER :: ib_fields
  INTEGER :: ib_couple
  INTEGER :: ib_method, ib1, ib2
!
!
!**----------------------------------------------------------------------
!
!** + Initialize through the namelist
!
  orca       = 0
  at42       = 0
  bt42       = 0
  lmdz       = 0 
  nb_fields  = 0
  dist       = 0
  gaus       = 0
  bili       = 0
  bicu       = 0
  cons_none  = 0
  cons_dest  = 0
  cons_frac  = 0
  at42_orca  = 0
  bt42_orca  = 0
  orca_at42  = 0
  orca_bt42  = 0
  bt42_at42  = 0
  orca_lmdz  = 0
  lmdz_orca  = 0

  il_unit = 6
  il_log = 88
  OPEN(unit=il_unit, file='error_in', status='old', form='formatted')
  READ(unit=il_unit, nml=par_in)
  OPEN(unit=il_log, file='error_log', form='formatted')
  write(il_log,*)'0.1 Namelist read '
  call flush(il_log)
  nb_grids = orca + at42 + bt42 + lmdz
  nb_methods = dist + gaus + bili + bicu + &
     cons_none + cons_dest + cons_frac
  write(il_log,*)'0.3 Namelist read : ', nb_methods,' methods'
  nb_couples = at42_orca + bt42_orca + orca_at42 + orca_bt42 + bt42_at42 &
    + orca_lmdz + lmdz_orca
  write(il_log,*)'0.4 Namelist read : ', nb_couples,' couples'
!
!*----------------------------------------------------------------
!
!** + Creation and definition of the "error.nc" auxilary file 
!
!** ++ Create the file
!
  CALL hdlerr(NF_CREATE('error.nc', 0, ig_file_id))
  write(il_log,*) '1.0 ig_file_id = ', ig_file_id
!
!** ++ Allocation of the id arrays
!
  ALLOCATE(ig_i(nb_grids))
  ALLOCATE(ig_j(nb_grids))
  ALLOCATE(ig_i_id(nb_grids))
  ALLOCATE(ig_j_id(nb_grids))
  ALLOCATE(ig_interp_id(nb_grids*nb_fields*nb_methods*nb_couples))
  ALLOCATE(ig_analyt_id(nb_grids*nb_fields*nb_methods*nb_couples))
  ALLOCATE(ig_interp_lat_id(nb_grids*nb_fields*nb_methods*nb_couples))
  ALLOCATE(ig_analyt_lat_id(nb_grids*nb_fields*nb_methods*nb_couples))
  ALLOCATE(ig_interp_lon_id(nb_grids*nb_fields*nb_methods*nb_couples))
  ALLOCATE(ig_analyt_lon_id(nb_grids*nb_fields*nb_methods*nb_couples))
  ALLOCATE(ig_error_id(nb_grids*nb_fields*nb_methods*nb_couples))

!
!** ++ For the different grids
!
  ig_index_remap = 0
  ig_index_grid = 0
  DO ib_grids = 1, 4

    write(il_log,*)'Definition : boucle grids ',ib_grids
    IF ((ib_grids .eq. 1) .and. (orca .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 1) THEN
	cg_add = 'o'
	ig_index_grid = ig_index_grid + 1
    END IF
    IF ((ib_grids .eq. 2) .and. (at42 .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 2) THEN
	cg_add = 'a'
	ig_index_grid = ig_index_grid + 1
    END IF
    IF ((ib_grids .eq. 3) .and. (bt42 .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 3) THEN
	cg_add = 'b'
	ig_index_grid = ig_index_grid + 1
    END IF
    IF ((ib_grids .eq. 4) .and. (lmdz .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 4) THEN
	cg_add = 'z'
	ig_index_grid = ig_index_grid + 1
    END IF
!
!** +++ Set the dimensions of the fields
!
    IF (ib_grids .eq. 1) THEN
	ig_i(ig_index_grid) = ig_io
	ig_j(ig_index_grid) = ig_jo
    ELSE IF (ib_grids .eq. 2) THEN
	ig_i(ig_index_grid) = ig_ia
	ig_j(ig_index_grid) = ig_ja
    ELSE IF (ib_grids .eq. 3) THEN
	ig_i(ig_index_grid) = ig_ib
	ig_j(ig_index_grid) = ig_jb
    ELSE IF (ib_grids .eq. 4) THEN
	ig_i(ig_index_grid) = ig_iz
	ig_j(ig_index_grid) = ig_jz
    END IF

    CALL hdlerr(NF_DEF_DIM(ig_file_id, 'ig_i'//cg_add, &
       ig_i(ig_index_grid), &
       ig_i_id(ig_index_grid)))
    write(il_log,*) '1.1 ig_i_id=', ig_i_id(ig_index_grid)
    CALL hdlerr(NF_DEF_DIM(ig_file_id, 'ig_j'//cg_add, &
       ig_j(ig_index_grid), &
       ig_j_id(ig_index_grid)))
    write(il_log,*) '1.2 ig_j_id=', ig_j_id(ig_index_grid)
!
!** +++ Set the dimensions
!
    iga_fld_dim(1)=ig_i_id(ig_index_grid)
    iga_fld_dim(2)=ig_j_id(ig_index_grid)

!
!** +++ For the different fields
!
    DO ib_fields = 1, nb_fields

      write(il_log,*)'Definition : boucle field ',ib_fields
!
!** +++ For the different remappings
!
      DO ib_couple = 1, 7

	write(il_log,*)'Definition : boucle couple ',ib_couple
	IF ((ib_grids .eq. 1) .and. (ib_couple.eq.1) &
	   .and. (at42_orca .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple at42_orca'
	    cg_file_int = 'ao'
	ELSE IF ((ib_grids .eq. 1) .and. (ib_couple.eq.2) &
	   .and. (bt42_orca .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple bt42_orca'
	    cg_file_int = 'bo'
	ELSE IF ((ib_grids .eq. 2) .and. (ib_couple.eq.3) &
	   .and. (orca_at42 .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple orca_at42'
	    cg_file_int = 'oa'
	ELSE IF ((ib_grids .eq. 3) .and. (ib_couple.eq.4) & 
	   .and. (orca_bt42 .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple orca_bt42'
	    cg_file_int = 'ob'
        ELSE IF ((ib_grids .EQ. 2) .AND. (ib_couple.EQ.5) & 
	   .and. (bt42_at42 .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple bt42_at42'
	    cg_file_int = 'ba'
        ELSE IF ((ib_grids .EQ. 4) .AND. (ib_couple.EQ.6) & 
	   .and. (orca_lmdz .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple orca_lmdz'
	    cg_file_int = 'oz'
        ELSE IF ((ib_grids .EQ. 1) .AND. (ib_couple.EQ.7) & 
	   .and. (lmdz_orca .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple lmdz_orca'
	    cg_file_int = 'zo'
	ELSE
	    CYCLE
	ENDIF

	cg_file_int_bis = cg_file_int

	DO ib_method = 1, 7
	  write(il_log,*)'Definition : boucle method ',ib_method

	  cg_file_int = cg_file_int_bis

	  IF ((ib_method.eq.1) .and. (dist.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'ds'  
	  ELSE IF ((ib_method.eq.2) .and. (gaus.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'ga'  
	  ELSE IF ((ib_method.eq.3) .and. (bili.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'bl'  
	  ELSE IF ((ib_method.eq.4) .and. (bicu.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'bc'  
	  ELSE IF ((ib_method.eq.5) .and. (cons_none.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'cn'  
	  ELSE IF ((ib_method.eq.6) .and. (cons_dest.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'cd'  
	  ELSE IF ((ib_method.eq.7) .and. (cons_frac.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'cf'
	  ELSE
	      CYCLE
	  END IF

	  IF (ib_fields .eq. 1) THEN
	      cg_file_int = TRIM(cg_file_int)//'1___'
	  ELSE IF (ib_fields .eq. 2) THEN
	      cg_file_int = TRIM(cg_file_int)//'2___'
	  ELSE IF (ib_fields .eq. 3) THEN
	      cg_file_int = TRIM(cg_file_int)//'3___'
	  END IF

	  ig_index_remap = ig_index_remap + 1

	  CALL hdlerr(NF_DEF_VAR (ig_file_id, cg_file_int//'int', &
	     NF_DOUBLE, 2, iga_fld_dim, ig_interp_id(ig_index_remap)))
	  write(il_log,*) '1.3 ig_interp_id = ', ig_interp_id(ig_index_remap)
	  CALL hdlerr(NF_PUT_ATT_TEXT (ig_file_id, &
	     ig_interp_id(ig_index_remap),'title', &
	     18,'Interpolated field'))

	  CALL hdlerr(NF_DEF_VAR (ig_file_id, cg_file_int//'ana', &
	     NF_DOUBLE, 2, iga_fld_dim, ig_analyt_id(ig_index_remap)))
	  write(il_log,*) '1.4 ig_analyt_id = ', ig_analyt_id(ig_index_remap)
	  CALL hdlerr(NF_PUT_ATT_TEXT (ig_file_id, &
	     ig_analyt_id(ig_index_remap),'title', &
	     18,'Analytic field    '))

	  CALL hdlerr(NF_DEF_VAR (ig_file_id, cg_file_int//'err', &
	     NF_DOUBLE, 2, iga_fld_dim, ig_error_id(ig_index_remap)))
	  write(il_log,*) '1.5 ig_error_id = ', ig_error_id(ig_index_remap)
	  CALL hdlerr(NF_PUT_ATT_TEXT (ig_file_id, &
	     ig_error_id(ig_index_remap),'title', &
	     18,'Error field      '))

	END DO
      END DO
    END DO
  END DO

  CALL hdlerr(NF_ENDDEF(ig_file_id))

!
!** + End of the definition sequence
!
!*----------------------------------------------------------------
!
!** + Filling of the "error.nc" auxilary file 
!
!** ++ For the different grids
!
  ig_index_remap = 0
  ig_index_grid = 0

  DO ib_grids = 1, 4

    write(il_log,*)'Filling : boucle grids ',ib_grids
    call flush(il_log)
    IF ((ib_grids .eq. 1) .and. (orca .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 1) THEN
	ig_index_grid = ig_index_grid + 1
    END IF
    IF ((ib_grids .eq. 2) .and. (at42 .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 2) THEN
	ig_index_grid = ig_index_grid + 1
    END IF
    IF ((ib_grids .eq. 3) .and. (bt42 .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 3) THEN
	ig_index_grid = ig_index_grid + 1
    END IF
    IF ((ib_grids .eq. 4) .and. (lmdz .eq. 0)) THEN
	CYCLE
    ELSE IF (ib_grids .eq. 4) THEN
	ig_index_grid = ig_index_grid + 1
    END IF
!
!** +++ Set the dimensions of the fields
!
    IF (ib_grids .eq. 1) THEN
	ig_i(ig_index_grid) = ig_io
	ig_j(ig_index_grid) = ig_jo
    ELSE IF (ib_grids .eq. 2) THEN
	ig_i(ig_index_grid) = ig_ia
	ig_j(ig_index_grid) = ig_ja
    ELSE IF (ib_grids .eq. 3) THEN
	ig_i(ig_index_grid) = ig_ib
	ig_j(ig_index_grid) = ig_jb
    ELSE IF (ib_grids .eq. 4) THEN
	ig_i(ig_index_grid) = ig_iz
	ig_j(ig_index_grid) = ig_jz
    END IF
!
!** +++ Set the dimensions
!
    iga_fld_dim(1)=ig_i_id(ig_index_grid)
    iga_fld_dim(2)=ig_j_id(ig_index_grid)
!
!** +++ Initialize the analytic and interpolated fields
!
!** ++++ Memory allocation
!
    ALLOCATE(rga_analytic(ig_i(ig_index_grid), ig_j(ig_index_grid)))
    ALLOCATE(rga_interpol(ig_i(ig_index_grid), ig_j(ig_index_grid)))
    ALLOCATE(rga_errorfld(ig_i(ig_index_grid), ig_j(ig_index_grid)))
    ALLOCATE(rga_analytic_lat(ig_i(ig_index_grid), ig_j(ig_index_grid)))
    ALLOCATE(rga_interpol_lat(ig_i(ig_index_grid), ig_j(ig_index_grid)))
    ALLOCATE(rga_analytic_lon(ig_i(ig_index_grid), ig_j(ig_index_grid)))
    ALLOCATE(rga_interpol_lon(ig_i(ig_index_grid), ig_j(ig_index_grid)))
    ALLOCATE(iga_mask(ig_i(ig_index_grid), ig_j(ig_index_grid)))
!
!** ++++ For the analytic fields
!
    IF (ib_grids .eq. 1) THEN
	cg_fld_name_lon = "torc.lon" 
	cg_fld_name_lat = "torc.lat" 
    ELSE IF (ib_grids .eq. 2) THEN
	cg_fld_name_lon = "at42.lon" 
	cg_fld_name_lat = "at42.lat" 
    ELSE IF (ib_grids .eq. 3) THEN
	cg_fld_name_lon = "bt42.lon" 
	cg_fld_name_lat = "bt42.lat" 
    ELSE IF (ib_grids .EQ. 4) THEN
	cg_fld_name_lon = "lmdz.lon" 
	cg_fld_name_lat = "lmdz.lat" 
    END IF

    DO ib_fields = 1, nb_fields
      write(il_log,*)'Filling : boucle field ',ib_fields
      call flush(il_log)

      IF (ib_grids .eq. 1) THEN
	  cg_file_ana = 'fldo'
	  cg_fld_name = "fieldo_"
      ELSE IF (ib_grids .eq. 2) THEN
	  cg_file_ana = 'flda'
	  cg_fld_name = "fielda_"
      ELSE IF (ib_grids .eq. 3) THEN
	  cg_file_ana = 'fldb'
	  cg_fld_name = "fieldb_"
      ELSE IF (ib_grids .eq. 4) THEN
	  cg_file_ana = 'fldz'
	  cg_fld_name = "fieldz_"
      END IF

      IF (ib_fields .eq. 1) THEN
	  cg_file_ana = TRIM(cg_file_ana)//'1.nc'
	  cg_fld_name = TRIM(cg_fld_name)//'1' 
      ELSE IF (ib_fields .eq. 2) THEN
	  cg_file_ana = TRIM(cg_file_ana)//'2.nc'
	  cg_fld_name = TRIM(cg_fld_name)//'2' 
      ELSE IF (ib_fields .eq. 3) THEN
	  cg_file_ana = TRIM(cg_file_ana)//'3.nc'
	  cg_fld_name = TRIM(cg_fld_name)//'3' 
      END IF

!
!** +++ For the different remappings
!
      DO ib_couple = 1, 7

	write(il_log,*)'Filling : boucle couple ',ib_couple
        call flush(il_log)
	IF ((ib_grids .eq. 1) .and. (ib_couple.eq.1) &
	   .and. (at42_orca .eq. 1)) THEN
	    cg_file_int = 'ao'
	ELSE IF ((ib_grids .eq. 1) .and. (ib_couple.eq.2) &
	   .and. (bt42_orca .eq. 1)) THEN
	    cg_file_int = 'bo'
	ELSE IF ((ib_grids .eq. 2) .and. (ib_couple.eq.3) &
	   .and. (orca_at42 .eq. 1)) THEN
	    cg_file_int = 'oa'
	ELSE IF ((ib_grids .eq. 3) .and. (ib_couple.eq.4) & 
	   .and. (orca_bt42 .eq. 1)) THEN
	    cg_file_int = 'ob'
        ELSE IF ((ib_grids .EQ. 2) .AND. (ib_couple.EQ.5) & 
	   .and. (bt42_at42 .eq. 1)) THEN
	    cg_file_int = 'ba'
        ELSE IF ((ib_grids .EQ. 4) .AND. (ib_couple.EQ.6) & 
	   .and. (orca_lmdz .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple orca_lmdz'
	    cg_file_int = 'oz'
        ELSE IF ((ib_grids .EQ. 1) .AND. (ib_couple.EQ.7) & 
	   .and. (lmdz_orca .eq. 1)) THEN
	    write(il_log,*)'Definition : boucle couple lmdz_orca'
	    cg_file_int = 'zo'
	ELSE
	    CYCLE
	ENDIF

	cg_file_int_bis = cg_file_int

	DO ib_method = 1, 7
	  write(il_log,*)'Filling : boucle method ',ib_method
          call flush(il_log)
	  cg_file_int = cg_file_int_bis

	  IF ((ib_method.eq.1) .and. (dist.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'ds'  
	  ELSE IF ((ib_method.eq.2) .and. (gaus.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'ga'  
	  ELSE IF ((ib_method.eq.3) .and. (bili.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'bl'  
	  ELSE IF ((ib_method.eq.4) .and. (bicu.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'bc'  
	  ELSE IF ((ib_method.eq.5) .and. (cons_none.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'cn'  
	  ELSE IF ((ib_method.eq.6) .and. (cons_dest.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'cd'  
	  ELSE IF ((ib_method.eq.7) .and. (cons_frac.eq.1)) THEN
	      cg_file_int = TRIM(cg_file_int)//'cf'
	  ELSE
	      CYCLE
	  END IF

	  IF (ib_fields .eq. 1) THEN
	      cg_file_int = TRIM(cg_file_int)//'1.nc'
	      cg_fld_name = TRIM(cg_fld_name)//'1' 
	  ELSE IF (ib_fields .eq. 2) THEN
	      cg_file_int = TRIM(cg_file_int)//'2.nc'
	      cg_fld_name = TRIM(cg_fld_name)//'2' 
	  ELSE IF (ib_fields .eq. 3) THEN
	      cg_file_int = TRIM(cg_file_int)//'3.nc'
	      cg_fld_name = TRIM(cg_fld_name)//'3' 
	  END IF

	  ig_index_remap = ig_index_remap + 1

	  CALL hdlerr(NF_OPEN(cg_file_ana, NF_NOWRITE, ig_file_ana_id))
	  write(il_log,*) '1.6 ig_file_ana_id ', ig_file_ana_id
          call flush(il_log)
	  iga_fld_start(1) = 1
	  iga_fld_start(2) = 1
	  iga_fld_start(3) = 1
	  iga_fld_count(1) = ig_i(ig_index_grid)
	  iga_fld_count(2) = ig_j(ig_index_grid)
	  iga_fld_count(3) = 1
	  write(il_log,*)'1.7 cg_fldnam ', cg_fld_name_lon
          CALL flush(il_log)
	  CALL hdlerr(NF_INQ_VARID(ig_file_ana_id, cg_fld_name_lon, &
	     ig_fld_id))
	  write(il_log,*)'1.8 ig_fld_id', ig_fld_id
          CALL flush(il_log)
	  CALL hdlerr(NF_GET_VARA_DOUBLE (ig_file_ana_id, ig_fld_id, &
	     iga_fld_start, iga_fld_count, rga_analytic_lon(:,:)))

	  write(il_log,*)'1.9 ig_analyt_id ', ig_analyt_id(ig_index_remap)
          call flush(il_log)
!	  CALL hdlerr(NF_PUT_VAR_DOUBLE (ig_file_id, &
!	     ig_analyt_id(ig_index_remap), &
!	     rga_analytic_lon))

	  write(il_log,*)'1.10 cg_fldnam ', cg_fld_name_lat
          CALL flush(il_log)
	  CALL hdlerr(NF_INQ_VARID(ig_file_ana_id, cg_fld_name_lat, &
	     ig_fld_id))
	  write(il_log,*)'1.11 ig_fld_id ', ig_fld_id
          CALL flush(il_log)
	  CALL hdlerr(NF_GET_VARA_DOUBLE (ig_file_ana_id, ig_fld_id, &
	     iga_fld_start, iga_fld_count, rga_analytic_lat(:,:)))

	  write(il_log,*)'1.12 ig_analyt_id ',ig_analyt_id(ig_index_remap)
          call flush(il_log)
!	  CALL hdlerr(NF_PUT_VAR_DOUBLE (ig_file_id, &
!	     ig_analyt_id(ig_index_remap), &
!	     rga_analytic_lon))

	  write(il_log,*)'1.13 cg_fldnam ', cg_fld_name
          CALL flush(il_log)
	  CALL hdlerr(NF_INQ_VARID(ig_file_ana_id, cg_fld_name, &
	     ig_fld_id))
	  write(il_log,*)'1.14 ig_fld_id', ig_fld_id
          CALL flush(il_log)
	  CALL hdlerr(NF_GET_VARA_DOUBLE (ig_file_ana_id, ig_fld_id, &
	     iga_fld_start, iga_fld_count, rga_analytic(:,:)))

	  write(il_log,*)'1.15 ig_analyt_id ',ig_analyt_id(ig_index_remap)
          CALL flush(il_log)
	  CALL hdlerr(NF_PUT_VAR_DOUBLE (ig_file_id, &
	     ig_analyt_id(ig_index_remap), &
	     rga_analytic))

	  write(il_log,*)'Min et max du champ analytic :', &
	     MINVAL(rga_analytic), MAXVAL(rga_analytic)
	  write(il_log,*)'Min et max du lat champ analytic :', &
	     MINVAL(rga_analytic_lat), MAXVAL(rga_analytic_lat)
	  write(il_log,*)'Min et max du lon champ analytic :', &
	     MINVAL(rga_analytic_lon), MAXVAL(rga_analytic_lon)

	  write(il_log,*) '1.16 cg_file_int ', cg_file_int 
	  CALL hdlerr(NF_OPEN(cg_file_int, NF_NOWRITE, ig_file_int_id))
	  write(il_log,*) '1.17 ig_file_int_id', ig_file_int_id

	  iga_fld_start(1) = 1
	  iga_fld_start(2) = 1
	  iga_fld_count(1) = ig_i(ig_index_grid)
	  iga_fld_count(2) = ig_j(ig_index_grid)

	  write(il_log,*)'1.18 cg_fldnam ', cg_fld_name_lon
          call flush(il_log)
	  CALL hdlerr(NF_INQ_VARID(ig_file_int_id, cg_fld_name_lon, &
	     ig_fld_id))
	  write(il_log,*)'1.19 ig_fld_id', ig_fld_id
          call flush(il_log)
	  CALL hdlerr(NF_GET_VARA_DOUBLE (ig_file_int_id, ig_fld_id, &
	     iga_fld_start, iga_fld_count, rga_interpol_lon(:,:)))

	  write(il_log,*)'1.19 ig_interp_id ',ig_interp_id(ig_index_remap)
          call flush(il_log)
!	  CALL hdlerr(NF_PUT_VAR_DOUBLE (ig_file_id, &
!	     ig_interp_id(ig_index_remap), &
!	     rga_interpol_lon))

	  write(il_log,*)'1.20 cg_fldnam ', cg_fld_name_lat
          call flush(il_log)
	  CALL hdlerr(NF_INQ_VARID(ig_file_int_id, cg_fld_name_lat, &
	     ig_fld_id))
	  write(il_log,*)'1.21 ig_fld_id', ig_fld_id
          call flush(il_log)
	  CALL hdlerr(NF_GET_VARA_DOUBLE (ig_file_int_id, ig_fld_id, &
	     iga_fld_start, iga_fld_count, rga_interpol_lat(:,:)))

	  write(il_log,*)'1.22 ig_interp_id ',ig_interp_id(ig_index_remap)
!	  CALL hdlerr(NF_PUT_VAR_DOUBLE (ig_file_id, &
!	     ig_interp_id(ig_index_remap), &
!	     rga_interpol_lon))

	  write(il_log,*) '1.23 cg_fldnam ', cg_fld_name
          CALL flush(il_log)
	  CALL hdlerr(NF_INQ_VARID(ig_file_int_id, cg_fld_name, &
	     ig_fld_id))
	  write(il_log,*) '1.24 ig_fld_id', ig_fld_id
          call flush(il_log)
	  CALL hdlerr(NF_GET_VARA_DOUBLE (ig_file_int_id, ig_fld_id, &
	     iga_fld_start, iga_fld_count, rga_interpol(:,:)))

	  write(il_log,*)'1.25 ig_interp_id ',ig_interp_id(ig_index_remap)
          CALL flush(il_log)
	  CALL hdlerr(NF_PUT_VAR_DOUBLE (ig_file_id, &
	     ig_interp_id(ig_index_remap), &
	     rga_interpol))

	  write(il_log,*)'Min et max du champ interpole :', &
	     MINVAL(rga_interpol), MAXVAL(rga_interpol)
	  write(il_log,*)'Min et max du lat champ interpole :', &
	     MINVAL(rga_interpol_lat), MAXVAL(rga_interpol_lat)
	  write(il_log,*)'Min et max du lon champ interpole :', &
	     MINVAL(rga_interpol_lon), MAXVAL(rga_interpol_lon)
          call flush(il_log)
!
!** +++ Get mask of target grid
!
          CALL hdlerr(NF_OPEN('masks.nc', NF_NOWRITE, ig_file_grid))
          IF (ib_grids .EQ. 1) THEN
              CALL hdlerr(NF_INQ_VARID(ig_file_grid, 'torc.msk', &
                 ig_msk_id))
              write(il_log,*)'torc_msk id = ',ig_msk_id 
          ELSE IF (ib_grids .eq. 2) then
              CALL hdlerr(NF_INQ_VARID(ig_file_grid, 'at42.msk', &
                 ig_msk_id)) 
              write(il_log,*)'at42_msk id = ',ig_msk_id
          ELSE IF (ib_grids .EQ. 3) THEN
              CALL hdlerr(NF_INQ_VARID(ig_file_grid, 'bt42.msk', &
                 ig_msk_id)) 
              write(il_log,*)'bt42_msk id = ',ig_msk_id
          ELSE IF (ib_grids .EQ. 4) THEN
              CALL hdlerr(NF_INQ_VARID(ig_file_grid, 'lmdz.msk', &
                 ig_msk_id)) 
              write(il_log,*)'lmdz_msk id = ',ig_msk_id
          ENDIF
          call flush(il_log)
          CALL hdlerr(NF_GET_VARA_INT (ig_file_grid, ig_msk_id, &
	     iga_fld_start, iga_fld_count, iga_mask(:,:)))
!
!** +++ For the error field
!
!** ++++ First check if there is a translation of the grid
!
!** For masked point on interpolated field (missing value)
!   put error = 0.0
	  WHERE (rga_analytic .gt. 0.000001)
	      rga_errorfld= (rga_interpol-rga_analytic)/rga_analytic
	  ELSE WHERE
	      rga_errorfld= rga_interpol
	  END WHERE
          WHERE (iga_mask .GT. 0) 
              rga_errorfld=0.0
          END WHERE
!
	  write(il_log,*)'1.22 ig_error_id ',ig_error_id(ig_index_remap)
          call flush(il_log)
	  CALL hdlerr(NF_PUT_VAR_DOUBLE (ig_file_id, &
	     ig_error_id(ig_index_remap), &
	     rga_errorfld))

	  write(il_log,*)'Checking remapping ', cg_file_int
	  write(il_log,*)'Min and max of the error field :', &
	     MINVAL(rga_errorfld), MAXVAL(rga_errorfld)
	  write(il_log,*)'Error mean : ',SUM(ABS(rga_errorfld))/(ig_i*ig_j)
          CALL flush(il_log)

!
!** ++ Close netCDF Dataset
!
	  CALL hdlerr(NF_CLOSE(ig_file_ana_id))
	  IF (ig_status .ne. NF_NOERR) CALL hdlerr(ig_status)
	  CALL hdlerr(NF_CLOSE(ig_file_int_id)) 
	  IF (ig_status .ne. NF_NOERR) CALL hdlerr(ig_status)


	END DO
      END DO
    END DO
!
!** ++++ Memory deallocation
!
    DEALLOCATE(rga_analytic)
    DEALLOCATE(rga_interpol)
    DEALLOCATE(rga_errorfld)
    DEALLOCATE(rga_analytic_lat)
    DEALLOCATE(rga_interpol_lat)
    DEALLOCATE(rga_analytic_lon)
    DEALLOCATE(rga_interpol_lon)
    DEALLOCATE(iga_mask)

  END DO

!
!** ++ Close error.nc netCDF Dataset
!
  CALL hdlerr(NF_CLOSE(ig_file_id))
  IF (ig_status .ne. NF_NOERR) CALL hdlerr(ig_status)
  DEALLOCATE(ig_j)
  DEALLOCATE(ig_i)
  DEALLOCATE(ig_i_id)
  DEALLOCATE(ig_j_id)
  DEALLOCATE(ig_interp_id)
  DEALLOCATE(ig_analyt_id)
  DEALLOCATE(ig_interp_lat_id)
  DEALLOCATE(ig_analyt_lat_id)
  DEALLOCATE(ig_interp_lon_id)
  DEALLOCATE(ig_analyt_lon_id)
  DEALLOCATE(ig_error_id)
!
!
!*----------------------------------------------------------------
!
  STOP
!
!*----------------------------------------------------------------
!

END PROGRAM gen_error

!
!*----------------------------------------------------------------
!*----------------------------------------------------------------
!

SUBROUTINE hdlerr(istatus)

  INTEGER                 :: istatus
  INCLUDE 'netcdf.inc'

  IF (istatus .ne. NF_NOERR) THEN
      print *, NF_STRERROR(istatus)
      stop 'stopped'
  ENDIF

  RETURN

END SUBROUTINE hdlerr

!
!*----------------------------------------------------------------
!*----------------------------------------------------------------
!
