/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "oif_plugin.h"

#include <qdeclarative.h>

#include "device.h"
#include "gesture.h"
#include "gestureevent.h"
#include "touch.h"
#include "oifdragarea.h"
#include "oifpincharea.h"
#include "oifrotatearea.h"
#include "oiftaparea.h"

void oifPlugin::registerTypes(const char* uri) {
  qmlRegisterType< OIFDragArea >(uri, 1, 0, "OIFDragArea");
  qmlRegisterType< OIFPinchArea >(uri, 1, 0, "OIFPinchArea");
  qmlRegisterType< OIFRotateArea >(uri, 1, 0, "OIFRotateArea");
  qmlRegisterType< OIFTapArea >(uri, 1, 0, "OIFTapArea");
  qmlRegisterType< Gesture >();
  qmlRegisterType< TouchLimits >();
  qmlRegisterType< GestureEvent >();
  qmlRegisterType< GestureProperty >();
  qmlRegisterType< Touch >();
  qmlRegisterType< Device >();
  qmlRegisterType< AxisInfo >();
}

Q_EXPORT_PLUGIN2(oif, oifPlugin)
