'''Defines the VmsSymbol class'''

class VmsSymbol:

    def __init__(self, symbolName):
	self.__name = symbolName
	self.__demangledName = None

    def name(self):
	if self.__demangledName:
	    return self.__demangledName
	else:
	    return self.__name

    def demangledName(self):
	return self.__demangledName

    def mangledName(self):
	return self.__name

    def setName(self, name):
	self.__name = name

    def demangle(self, demangledName):
	self.__demangledName = demangledName

    def display(self, detailed=0):
	if detailed:
	    print 'Name: %s' % self.__name
	    print 'Demangled name:'
	    print self.__demangledName
	    print 'Type: %s' % self.type()
	else:
	    print self.name()

    def isData(self):
	return 0

    def isFunction(self):
	return 0

    def isUndefined(self):
	return not self.isData() and not self.isFunction()

    def isAmbiguous(self):
	return self.isData() and self.isFunction()

    def type(self):
	if self.isData():
	    if self.isFunction():
		return "ambiguous"
	    else:
		return "data"
	elif self.isFunction():
	    return "function"
	else:
	    return "unknown"
