#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
#################################################################################

if test "$3" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$3" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$3" = sfcb
then
	/etc/init.d/sfcb stop
fi

$6/registration/OpenDRIM_SSHProtocolEndpoint.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHProtocolCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_TCPProtocolEndpoint.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHSessionSettingData.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHProtocolProvidesEndpoint.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_HostedSSHAccessPoint.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_RegisteredSSHProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHConformsToProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHProtocolEndpointBindsToTCPProtocolEndpoint.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHProtocolService.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHServiceAccessBySAP.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHServiceSettingData.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SSHSettingData.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_HostedSSHService.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_TCPProtocolEndpointBindsToIPProtocolEndpoint.sh $1 $2 $3 $4 $5 $6

if test "$3" = sfcb
then
	/etc/init.d/sfcb start
fi

