# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1849-1 (xml-security-c)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64561);
 script_cve_id("CVE-2009-0217");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1849-1 (xml-security-c)");

 desc = "The remote host is missing an update to xml-security-c
announced via advisory DSA 1849-1.

It was discovered that the W3C XML Signature recommendation contains a
protocol-level vulnerability related to HMAC output truncation.  This
update implements the proposed workaround in the C++ version of the
Apache implementation of this standard, xml-security-c, by preventing
truncation to output strings shorter than 80 bits or half of the
original HMAC output, whichever is greater.

For the old stable distribution (etch), this problem has been fixed in
version 1.2.1-3+etch1.

For the stable distribution (lenny), this problem has been fixed in
version 1.4.0-3+lenny2.

For the unstable distribution (sid), this problem has been fixed in
version 1.4.0-4.

We recommend that you upgrade your xml-security-c packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201849-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1849-1 (xml-security-c)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libxml-security-c-doc", ver:"1.2.1-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml-security-c-dev", ver:"1.2.1-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml-security-c12", ver:"1.2.1-3+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml-security-c14", ver:"1.4.0-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml-security-c-dev", ver:"1.4.0-3+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
