# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11356 (tomcat6)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66330);
 script_cve_id("CVE-2008-5515", "CVE-2009-0033", "CVE-2009-0580", "CVE-2009-0781", "CVE-2009-0783");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 10 FEDORA-2009-11356 (tomcat6)");

 desc = "The remote host is missing an update to tomcat6
announced via advisory FEDORA-2009-11356.

Update Information:

Fix for CVE-2008-5515, CVE-2009-0033, CVE-2009-0580, CVE-2009-0781, and
CVE-2009-0783.

ChangeLog:

* Mon Nov  9 2009 Alexander Kurtakov  0:6.0.20-1
- Update to 6.0.20. Fixes CVE-2009-0033,CVE-2009-0580.

References:

[ 1 ] Bug #533903 - CVE-2009-0033 CVE-2009-0580 CVE-2009-0783 CVE-2008-5515 CVE-2009-0781 Multiple tomcat6 vulnerabilities [Fedora all]
https://bugzilla.redhat.com/show_bug.cgi?id=533903

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update tomcat6' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11356

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-11356 (tomcat6)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"tomcat6", rpm:"tomcat6~6.0.20~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat6-admin-webapps", rpm:"tomcat6-admin-webapps~6.0.20~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat6-docs-webapp", rpm:"tomcat6-docs-webapp~6.0.20~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat6-javadoc", rpm:"tomcat6-javadoc~6.0.20~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat6-jsp-2.1", rpm:"tomcat6-jsp-2.1~api~6.0.20", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat6-lib", rpm:"tomcat6-lib~6.0.20~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat6-servlet-2.5", rpm:"tomcat6-servlet-2.5~api~6.0.20", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomcat6-webapps", rpm:"tomcat6-webapps~6.0.20~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
