###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ImageMagick FEDORA-2010-0295
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861609);
  script_version("$Revision: 8150 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "FEDORA", value: "2010-0295");
  script_cve_id("CVE-2009-1882");
  script_name("Fedora Update for ImageMagick FEDORA-2010-0295");
  desc = "

  Vulnerability Insight:
  ImageMagick is an image display and manipulation tool for the X
  Window System. ImageMagick can read and write JPEG, TIFF, PNM, GIF,
  and Photo CD image formats. It can resize, rotate, sharpen, color
  reduce, or add special effects to an image, and when finished you can
  either save the completed work in the original format or a different
  one. ImageMagick also includes command line programs for creating
  animated or transparent .gifs, creating composite images, creating
  thumbnail images, and more.
  
  ImageMagick is one of your choices if you need a program to manipulate
  and display images. If you want to develop your own applications
  which use ImageMagick code or APIs, you need to install
  ImageMagick-devel as well.


  Affected Software/OS:
  ImageMagick on Fedora 11

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2010-January/msg00317.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ImageMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC11")
{

  if(isrpmvuln(pkg:"ImageMagick", rpm:"ImageMagick~6.5.1.2~2.fc11", rls:"FC11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}