###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_image_hosting_script_dpi_detect.nasl 6150 2009-12-10 16:25:36Z dec $
#
# Clixint Image Hosting Script DPI Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801081);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Clixint Image Hosting Script DPI Version Detection");
  desc = "
  Overview: This script finds the installed Clixint Image Hosting Script
  DPI version and saves the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of Clixint Image Hosting Script DPI in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

dpiPort = get_http_port(default:80);
if(!dpiPort){
  exit(0);
}

foreach path (make_list("/", "/DPI11F", "/dpi", "/dpi11f", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:dpiPort);
  rcvRes = http_send_recv(port:dpiPort, data:sndReq);
  if("image hosting script" >< rcvRes && "DPI" >< rcvRes)
  {
    dpiVer = eregmatch(pattern:"DPI (([0-9.]+)( ?[a-zA-z]+)?)" , string:rcvRes);
    if(dpiVer[1] != NULL)
    {
      version = ereg_replace(pattern:" ", replace:".", string:dpiVer[1]);
      set_kb_item(name:"www/" + dpiPort + "/ImageHostingScript/DPI",
           value:version + " under " + path);
      security_note(data:"Clixint Image Hosting Script version " + version +
                         " running at location " + path + " was detected on the host");
    }
  }
}
