###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mymsg_detect.nasl 5165 2009-10-12 12:58:24Z oct $
#
# MyMsg Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800951);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("MyMsg Version Detection");
  desc = "
  Overview: This script detects the installed version of MyMsg
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of MyMsg");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

mymsgPort = get_http_port(default:80);
if(!mymsgPort){
  mymsgPort = 80;
}

if(!get_port_state(mymsgPort)){
  exit(0);
}

foreach dir (make_list("/", "/mymsg", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/Login.php"), port:mymsgPort);
  rcvRes = http_send_recv(port:mymsgPort, data:sndReq);

  if(("MyMsg" >< rcvRes) && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    mymsgVer = eregmatch(pattern:"MyMsg ([0-9.]+)", string:rcvRes);
    if(mymsgVer[1] != NULL)
    {
      set_kb_item(name:"www/" + mymsgPort + "/MyMsg",
                  value:mymsgVer[1] + " under " + dir);
      security_note(data:"MyMsg version " + mymsgVer[1] + " running at location "
                         + dir + " was detected on the host");
    }
  }
}
