###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_titan_ftp_server_dos_vuln.nasl 994 2009-02-09 15:00:29Z feb $
#
# TitanFTP Server Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800237);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-6082");
  script_bugtraq_id(31757);
  script_name("TitanFTP Server Denial of Service Vulnerability");
  desc = "

  Overview: This host is running TitanFTP Server and is prone to Denial of
  Service Vulnerability.

  Vulnerability Insight:
  Error exists while processing the SITE WHO command on FTP service which
  in causes extensive usages of CPU resources.

  Impact:
  Successful exploitation will let the attacker cause denial of service to
  the application by sending crafted requests to the FTP Server.

  Affected Software/OS:
  TitanFTP Server version prior to 6.26.631 on Windows.

  Fix:
  Upgrade to the latest version 6.26.631 or later.
  http://www.southrivertech.com/download/index.html

  References:
  http://secunia.com/advisories/32269
  http://www.milw0rm.com/exploits/6753

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of TitanFTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_titan_ftp_detect.nasl", "find_service.nes");
  script_require_keys("TitanFTP/Server/Ver");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  exit(0);
}

titanVer = get_kb_item("TitanFTP/Server/Ver");
if(!titanVer){
  exit(0);
}

# Grep for TitanFTP Server version 6.26.630 or prior.
if(version_is_less_equal(version:titanVer, test_version:"6.26.630")){
  security_warning(ftpPort);
}
