###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for kdelibs vulnerabilities USN-447-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840091);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "447-1");
  script_cve_id("CVE-2007-1308", "CVE-2007-1564");
  script_name( "Ubuntu Update for kdelibs vulnerabilities USN-447-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Konqueror did not correctly handle iframes from
  JavaScript.  If a user were tricked into visiting a malicious website,
  Konqueror could crash, resulting in a denial of service. (CVE-2007-1308)
  
  A flaw was discovered in how Konqueror handled PASV FTP responses.  If a
  user were tricked into visiting a malicious FTP server, a remote
  attacker could perform a port-scan of machines within the user's
  network, leading to private information disclosure. (CVE-2007-1564)

  Affected Software/OS:
  kdelibs vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000515.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdelibs vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"kdelibs-bin", ver:"3.5.2-0ubuntu18.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.2-0ubuntu18.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.2-0ubuntu18.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.2-0ubuntu18.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.2-0ubuntu18.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.2-0ubuntu18.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.2-0ubuntu18.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.5-0ubuntu3.1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.5-0ubuntu3.1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.5-0ubuntu3.1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.5-0ubuntu3.1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.5-0ubuntu3.1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.5-0ubuntu3.1.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"kdelibs-bin", ver:"3.4.3-0ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.4.3-0ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2-dbg", ver:"3.4.3-0ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2", ver:"3.4.3-0ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.4.3-0ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.4.3-0ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.4.3-0ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}