###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_cups_detect.nasl 1967 2009-04-27 16:01:29Z apr $
#
# CUPS Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900348);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("CUPS Version Detection");
  desc = "
  Overview: This script detects the installed version of CUPS (Common UNIX
  Printing System) and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of CUPS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 631);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

cupsPort = get_http_port(default:631);
if(!cupsPort){
  cupsPort = 631;
}

if(!get_port_state(cupsPort)){
  exit(0);
}

foreach dir (make_list("/", "/admin/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir), port:cupsPort);
  rcvRes = http_send_recv(port:cupsPort, data:sndReq);

  if("CUPS" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    ver = eregmatch(pattern: "<TITLE>(Home|Administration) - CUPS ([0-9.]+)([a-z][0-9])?"+
                             "</TITLE>", string:rcvRes);
    if(ver[2] != NULL)
    {
      if(ver[3] != NULL){
        cupsVer = ver[2] + "." + ver[3];
      }
      else cupsVer = ver[2];

      set_kb_item(name:"www/"+ cupsPort + "/CUPS", value:cupsVer);
      security_note(data:"CUPS version " + cupsVer + " running at location " +
                                            dir + " was detected on the host");
    }
  }
}
