Minutes from 87th OpenVDB TSC meeting, April 20th, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B, *Andre* P.

Additional Attendees: JT Nelson (Blender), Bruce Chernaik (Intel),
Roman Zulak (ImageWorks), Johannes Meng (Intel), Sergio Rojas

Regrets: none

Agenda:

1) Confirm Quorum
2) Secretary
3) Forum
4) Website
5) Cebas reporting issue freeing grids
6) Status on OpenEXR dependency
7) Screen sharing
8) AX Update
9) InternalNode ValueOff iterator
10) String Grids
11) VDB Viewer
12) PR1010 - Active Voxel Count PR
13) PR1024 - DynamicNodeManager Grain Size PR
14) PR1033 - Fix to VDB Rebuild SDF SOP PR
15) PR1031 - VDB Merge SOP PR
16) Mantra Rendering Performance - VDB vs Houdini Volume
17) Blind Data
18) TBB 2021 update
19) Houdini Transforms
20) TypedAttributeArray ptr to buffer
21) Next Meeting

1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Nick Avramoussis

3) Forum

Discussion around the google forum which can no longer be embedded into the
website. Github discussion seems like a good replacement. We could make the
google forum read only and/or remove the link from the openvdb forum website
and instead point to the github discussions page. We should vet github
discussions before transitioning. Dan to enable discussions on the website repo
for us to test.

4) Website

Ken has updated the website with new images from ILM.

5) Cebas reporting issue freeing grids

A client is observing a significant performance slowdown running rasterization
code thousands of times, specifically on Windows. There is no IO involved. This
sounds like an allocator or threading issue. Ken to feedback and suggest trying
tbbmalloc if they are not already.

Related google forum post: https://groups.google.com/g/openvdb-forum/c/MQZOpQ3h5lM/m/BKhEG75yBAAJ

6) Status on OpenEXR dependency

This has been merged into master but not yet released. Ken has run into issues
building OpenVDB and believes they are related to this. Ken to investigate
further and feedback.

7) Screen sharing

Tested, only Ken (the host) is able to screen share. Nick to contact John for
assistance.

8) AX Update

Major update to AX coming which introduces active tile streaming and
significant performance enhancements for Volume kernels due to better
vectorization. The following 3 topics were encountered from this work.

9) InternalNode ValueOff iterator

Nick, this iterator runs of child nodes. The ValueOff iterators on the grid,
tree and leaf node, do not. Nick, caught out unexpectedly by this behaviour,
is there any way this could be changed? Probably not directly. Ken, you can
create a mask that represents these values but, if you're using a non-const
iterator, how do you then change these values if you write to them. Best
solution would be to make the documentation more clear (but it is difficult)
as people already expect this API to exists in the same way across all VDB
nodes.

10) String Grids

Nick, AX works with string grids but, during unit testing, found that vdb_print
crashes when trying to read one in. There are no tests for string grids in VDB
but they are a supported type by the serializer. All agreed we should deprecate
the typedef whilst retaining support and see if anyone gets in touch with
concerns.

11) VDB Viewer

Nick, discussions with JT about ways to introduce people to AX. An interactive
viewer is needed which at the moment means users have to install Houdini. The
vdb viewer is in a bit of a weird state. It lives in the main repo but is only
used by the vdb view binary. It advertises an API but has no tests and is not
installed. NanoVDB contains a new viewer which is far superior but more complex
to build. All agree a simple, basic viewer makes sense to exist alongside a
more feature full application. Agreement that the viewer directory should not
be advertised as an API and be moved to live alongside the vdb_view binary.
For AX, we should wait for the more complicated viewer which will support the
features AX needs. Nick to address the vdb_view library.

12) PR1010 - Active Voxel Count PR

Dan, feedback regarding API stability has been implemented now. Ken to review
with a deadline to merge next week.

13) PR1024 - DynamicNodeManager Grain Size PR

Dan, PR exposes 2 grain sizes for leaf nodes and tiles. It's hard to automate
these values and makes defaults difficult to specify. Jeff, part of the problem
is the structure of the VDB tree resulting in 8 root child nodes when data is
created with each sign flip. Jeff, we should investigate changing this for
VDB 9 and change where we centre grids. TSC to review the PR.

14) PR1033 - Fix to VDB Rebuild SDF SOP PR

Dan, "bugfix" due to the nature of the rebuild operation which doesn't fall
into the category of producing a "new" grid (in-place op). The grid's metadata
is dropped and shouldn't be. This PR addresses the issue specifically in
Houdini. Nick approved, Jeff to review.

15) PR1031 - VDB Merge SOP PR

Dan, new merge functionality targeted for 8.1 is up. New Merge Houdini SOP and
sum operator. To be reviewed by TSC.

16) Mantra Rendering Performance - VDB vs Houdini Volume

Dan, converting to Houdini volumes seems to result in better rendering
performance. Dan, to collect some more examples so we can examine the
differences.

17) Blind Data

Dan, proposal to add a 32bit int to the leaf nodes which shouldn't change
their size on 64bit architecture. Jeff, should this data be saved or copied?
Dan, purely transient data which is never serialized. Designed to target
individual algorithms.

18-20) Time

21) Next Meeting

Next meeting is April 27th, 2021. 12pm-1pm EST (GMT-5).
