// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DeleteVpcPeeringRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* vpcPeeringId ID  */
    VpcPeeringId string `json:"vpcPeeringId"`
}

/*
 * param regionId: Region ID (Required)
 * param vpcPeeringId: vpcPeeringId ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteVpcPeeringRequest(
    regionId string,
    vpcPeeringId string,
) *DeleteVpcPeeringRequest {

	return &DeleteVpcPeeringRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/vpcPeerings/{vpcPeeringId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        VpcPeeringId: vpcPeeringId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param vpcPeeringId: vpcPeeringId ID (Required)
 */
func NewDeleteVpcPeeringRequestWithAllParams(
    regionId string,
    vpcPeeringId string,
) *DeleteVpcPeeringRequest {

    return &DeleteVpcPeeringRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/vpcPeerings/{vpcPeeringId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        VpcPeeringId: vpcPeeringId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteVpcPeeringRequestWithoutParam() *DeleteVpcPeeringRequest {

    return &DeleteVpcPeeringRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/vpcPeerings/{vpcPeeringId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *DeleteVpcPeeringRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param vpcPeeringId: vpcPeeringId ID(Required) */
func (r *DeleteVpcPeeringRequest) SetVpcPeeringId(vpcPeeringId string) {
    r.VpcPeeringId = vpcPeeringId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteVpcPeeringRequest) GetRegionId() string {
    return r.RegionId
}

type DeleteVpcPeeringResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteVpcPeeringResult `json:"result"`
}

type DeleteVpcPeeringResult struct {
}