//=======================================================================
// gconfig.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_GCONFIG_H
#define GPACO_GCONFIG_H

#include "paco/baseconfig.h"
#include <glibmm/ustring.h>
#include <glib/gkeyfile.h>
#include <vector>


namespace Gpaco {

class MainWindow;

class GConfig : public Paco::BaseConfig
{
	public:

	static void init();
	static void saveSettings(MainWindow&);

	static bool hour()				{ return sHour; }
	static int width()				{ return sWidth; }
	static int height()				{ return sHeight; }
	static int xPos()				{ return sXPos; }
	static int yPos()				{ return sYPos; }
	static std::vector<int>& cols()	{ return sCols; }

	static void hour(bool set)		{ sHour = set; }

	private:

	GConfig();
	GConfig(GConfig&);
	GConfig& operator=(GConfig&);
	~GConfig();

	static bool sHour;
	static int sWidth;
	static int sHeight;
	static int sXPos;
	static int sYPos;
	static std::vector<int> sCols;

	Glib::ustring mGpacoRC;
	GKeyFile* mKeyFile;

	static int const DEFAULT_WIDTH	= 500;
	static int const DEFAULT_HEIGHT	= 500;
	static int const DEFAULT_XPOS	= 0;
	static int const DEFAULT_YPOS	= 0;

	void getValue(char const* tag, bool* var);
	void getValue(char const* tag, int* var);

};

}	// namespace Gpaco


#endif  // GPACO_GCONFIG_H

