add_comment = function(data, username) {
  console.log('Adding comment ' + data.comment_added);
  var field = $('#comments');

  var edit_btn = ''
  if (data.request_id && data.project){
    edit_btn = '<a class="btn btn-secondary btn-sm edit_btn" \
        href="/' + data.project + '/pull-request/' + data.request_id + '/comment/' + data.comment_id + '/edit" \
        data-comment="' + data.comment_id + '" \
        data-objid="' + data.request_id + '"> \
        <i class="fa fa-pencil"></i> \
    </a>';
  }
  var inline = false;
  if (data.commit_id){
    inline = true;
    edit_btn = '';
  }

  if (data.notification){
    var _data = '<div class="d-flex align-items-center px-3 py-2 mb-3">'
                +'<div class="">'
                + '<img src="'+data.avatar_url+'"/>'
                +'</div>'
                +'<span class="font-size-09 autogenerated-comment pl-4">'
                + data.comment_added
                +'</span>'
                +'<div class="text-muted ml-auto">'
                + '<span title="'+data.comment_date+'">'
                + 'seconds ago</span>'
                +'</div>'
               +'</div>'

  } else {
    var _csrf = $('#csrf_token').clone();
    var _data =
      '<div class="card mb-4 clearfix">'
    + '  <div id="comment-' + data.comment_id + '" class="card-header bg-light d-flex align-items-center px-3 py-2">'
    + '    <div>'
    + '      <img class="avatar circle" src="' + data.avatar_url + '"/>'
    + '      <a href="/user/' + data.comment_user + '"'
    + '        class="notblue font-weight-bold">'+data.comment_user+'</a>'
    + '      <a class="notblue" title="Permalink to this headline"'
    if (data.comment_id) {
      _data += ' href="#comment-' + data.comment_id + '"';
    }
    _data += '><span>commented seconds ago</span>'
    + '      </a>'
    + '    </div>';

    if ( data.comment_user == username && data.comment_id !== undefined) {
      _data = _data
      + '    <div class="issue_actions ml-auto">'
      + '      <a href="/' + data.project + '/pull-request/' + data.request_id + '/comment/' + data.comment_id + '/edit"'
      + '         class="btn btn-outline-primary border-0" data-comment="' + data.comment_id + '" data-objid="' + data.request_id + '">'
      + '        <i class="fa fa-pencil"  title="Edit comment"></i>'
      + '      </a>'
      + '      <button class="btn btn-outline-primary border-0 delete_comment_btn" title="Remove comment" name="drop_comment" '
      + '         value="' + data.comment_id + '" type="submit" >'
      + '        <i class="fa fa-trash"></i>'
      + '      </button>'
      + '    </div>';
    }

    _data = _data
    + '  </div>'
    + '  <div class="card-body pb-1">'
    + '    <section class="issue_comment">'
    + '      <div>'
    + '        <span class="edit_date" title=""></span>'
    + '        <span class="comment_text comment_body">'
    + emojione.toImage(data.comment_added)
    + '        </span>'
    + '      </div>'
    + '    </section>'
    + '  </div>'
    + '</div>'

  }

  if (inline){
    // Inline comment
    console.log('Inline');

    //add comment to files changed tab
    var field = $('[data-commit="' + data.commit_id + '"]').parent();
    var id = field.children().children().attr('id').split('_')[0];
    var row = $('#' + id + '_' + (parseInt(data.line) + 1)).parent().parent();
    row.before('<tr><td class="p-3 border" colspan="3">'+_data+'</td></tr>');
    console.log(row);

    //add comment to comments tab
    var cfield = $('#request_comment');
    cfield.append(_data);

  } else {
    // Generic comment
    console.log('generic');
    var field = $('#request_comment');
    field.append(_data);
  }
}

update_comment = function(data) {
  console.log('Updating comment ' + data.comment_id);
  var field = $('#comment-' + data.comment_id).parent();
  var edited = field.find('.text-muted');
  if (edited.length == 0) {
    $(field.find('aside')).before(
        '<small class="text-muted">Edited a just now by '
        + data.comment_editor + '</small>');
  } else {
    edited.html('Edited a just now by ' + data.comment_editor)
  }
  field.find('.comment_body').html(data.comment_updated);
  field.find('.issue_actions').show();
  field.find('.issue_comment').show();
  field.find('.edit_comment').remove();
}

process_event = function(data, requestid, username){
  console.log(data);
  var category = null;
  var originalTitle = document.title;
  if (data.comment_added){
    add_comment(data, username);
    category = 'comment';
  } else if (data.comment_updated){
    update_comment(data);
    category = 'Comment updated';
  } else {
    console.log('Unknown data');
  }

  if (category && !document.hasFocus()) {
    var int = setInterval(function(){
      var title = document.title;
      document.title = (title === originalTitle) ? category : originalTitle;
    }, 750);

    $(window).focus(function () {
      clearInterval(int);
      document.title = originalTitle;
    });
  }
}
