# *Percona XtraBackup* 8.0.28-20


* **Date**

    April 26, 2022


[Percona XtraBackup for MySQL Databases](https://www.percona.com/software/mysql-database/percona-xtrabackup) enables MySQL backups without blocking user queries. Percona XtraBackup is ideal for companies with large data sets and mission-critical applications that cannot tolerate long periods of downtime. Offered free as an open source solution, Percona XtraBackup drives down backup costs while providing unique features for MySQL backups.

## Release Highlights

The log statements structure in Percona XtraBackup has been improved. Now, the error logs have a standard structure. The uniformity of the headers makes it easier to follow an operation’s progress or review the log to diagnose issues. The improved log structure is displayed in the backup, prepare, move-back/copy-back error logs.

Each log statement has the following attributes:


* **Timestamp** - a timestamp for when the event occurred in a UTC format.


* **Severity** - the severity level of a statement indicates the importance of an event.


* **ID** - this identifier is currently not used but may be used in future versions.


* **Context** - the name of the module that issued the log statement, such as **XtraBackup**, **InnoDB**, or **Server**.


* **Message** - a description of the event generated by the module.

## New Features


* [PXB-2670](https://jira.percona.com/browse/PXB-2670): Improves the error logging framework in Percona XtraBackup.

## Bugs Fixed


* [PXB-1676](https://jira.percona.com/browse/PXB-1676): The error message after creating a backup was incorrect.


* [PXB-2716](https://jira.percona.com/browse/PXB-2716): Fix for a compilation error on systems without fallocate. (Thanks to user Bo98 for providing the patch to fix this issue.)


* [PXB-2506](https://jira.percona.com/browse/PXB-2506): During copy back and move back operations, added a check if the backup is fully prepared. Percona XtraBackup throws an error if the backup is not prepared or was prepared with –apply-log-only.


* [PXB-2662](https://jira.percona.com/browse/PXB-2662): Percona XtraBackup exited during prepare when creating an incremental backup using page tracking.


* [PXB-2714](https://jira.percona.com/browse/PXB-2714): Fix for a memory leak on the keyring component.


* [PXB-2697](https://jira.percona.com/browse/PXB-2697): Undefined symbols in macOS resulted in an error when linked with Percona XtraBackup 8.0.27.


* [PXB-2722](https://jira.percona.com/browse/PXB-2722): Fix for when via command line, a password, passed using the -p option, was written into the backup tool_command in xtrabackup_info.

## Useful Links


* The [Percona XtraBackup installation instructions](https://www.percona.com/doc/percona-xtrabackup/8.0/installation.html)


* The [Percona XtraBackup downloads](https://www.percona.com/downloads/Percona-XtraBackup-LATEST/)


* The [Percona XtraBackup GitHub location](https://github.com/percona/percona-xtrabackup)


* To contribute to the documentation, review the [Documentation Contribution Guide](https://github.com/percona/percona-xtrabackup/blob/8.0/storage/innobase/xtrabackup/doc/source/contributing.md)
