<?php
/**
 * Test the handler for a LDAP master/slave setup.
 *
 * PHP version 5
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @link     http://pear.horde.org/index.php?package=Kolab_Server
 */

/**
 * Require our basic test case definition
 */
require_once __DIR__ . '/../../../LdapTestCase.php';

/**
 * Test the handler for a LDAP master/slave setup.
 *
 * Copyright 2009-2016 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Kolab
 * @package  Kolab_Server
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @link     http://pear.horde.org/index.php?package=Kolab_Server
 */
class Horde_Kolab_Server_Class_Server_Connection_SplittedldapTest
extends Horde_Kolab_Server_LdapTestCase
{
    public function testMethodConstructHasParameterNetldap2ReadConnectionAndParameterNetldap2WriteConnection()
    {
        $this->skipIfNoLdap();
        $ldap_read = $this->getMock('Horde_Ldap');
        $ldap_write = $this->getMock('Horde_Ldap');
        $conn = new Horde_Kolab_Server_Connection_Splittedldap($ldap_read, $ldap_write);
    }

    public function testMethodConstructHasPostconditionThatTheGivenServersWereStored()
    {
        $this->skipIfNoLdap();
        $ldap_read = $this->getMock('Horde_Ldap');
        $ldap_write = $this->getMock('Horde_Ldap');
        $conn = new Horde_Kolab_Server_Connection_Splittedldap($ldap_read, $ldap_write);
        $this->assertSame($ldap_read, $conn->getRead());
        $this->assertSame($ldap_write, $conn->getWrite());
    }

    public function testMethodGetreadHasResultNetldap2TheHandledConnection()
    {
        $this->skipIfNoLdap();
        $ldap_read = $this->getMock('Horde_Ldap');
        $ldap_write = $this->getMock('Horde_Ldap');
        $conn = new Horde_Kolab_Server_Connection_Splittedldap($ldap_read, $ldap_write);
        $this->assertInstanceOf('Horde_Ldap', $conn->getRead());
        $this->assertInstanceOf('Horde_Ldap', $conn->getWrite());
    }

    public function testMethodGetwriteHasResultNetldap2TheHandledConnection()
    {
        $this->skipIfNoLdap();
        $ldap_read = $this->getMock('Horde_Ldap');
        $ldap_write = $this->getMock('Horde_Ldap');
        $conn = new Horde_Kolab_Server_Connection_Splittedldap($ldap_read, $ldap_write);
        $this->assertFalse($conn->getWrite() === $conn->getRead());
    }
}
