#!/usr/bin/perl
#
# Based on afterglow snort alert parser
# pattern matching stuff is Copyright (c) 2006 by Raffael Marty
# PCV things are Copyright (c) 2008 Sebastien Tricaud
#

our ($timestamp,$sip,$dip,$sport,$dport,$sid,$name,$classification,$proto,$priority,$ttl,$tos,$id,$iplen,$dgmlen,$flags,$seq,$ack,$win,$tcplen);

print "header {\n";
print "    title = \"Syslog picviz analysis\";\n";
print "}\n";

print "axes {\n";
print "    timeline time [label=\"Time\"];\n"; # Time
print "    ipv4     sip [label=\"Source IP\"];\n"; # Machine
print "    ipv4     dip [label=\"Destination IP\"];\n"; # Application
print "    string   class [label=\"Classification\",relative=\"true\"];\n"; # Log
print "}\n";

print "data {\n";

while (my $line = <>) {
	chomp;

	# [**] [1:654:5] SMTP RCPT TO overflow [**]
	# [Classification: Attempted Administrator Privilege Gain] [Priority: 1]
	# 07/12-18:44:57.688640 213.144.137.88:3108 -> 62.2.33.102:25
	# TCP TTL:240 TOS:0x10 ID:0 IpLen:20 DgmLen:2338
	# ***AP*** Seq: 0x6E19100F  Ack: 0xA4FBB7BC  Win: 0x7DDB  TcpLen: 20
	# [Xref => http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2001-0260]
	# [Xref => http://www.securityfocus.com/bid/2283]

	if ($line =~ /\s*\[\*\*\] \[(\S+)\] (.*) \[\*\*\]/) { ($sid,$name) = ($1,$2); }
	if ($line =~ /\[Classification: (.*?)\] \[Priority: (\S+)\]/) { ($classification,$priority) = ($1,$2); }
	if ($line =~ /\d+\/\d+-(\d+:\d+:\d+).\d+ (\S+?)(?::(\d+))? -> ([^:]+)(?::(\d+))?/) { ($timestamp,$sip,$sport,$dip,$dport) = ($1,$2,$3,$4,$5); }
	if ($line =~ /(\S+) TTL:(\d+) TOS:(\S+) ID:(\d+) IpLen:(\d+) DgmLen:(\d+)/) { ($proto,$ttl,$tos,$id,$iplen,$dgmlen) = ($1,$2,$3,$4,$5,$6); }
	if ($line =~ /(\S+) Seq: (\S+)  Ack: (\S+)  Win: (\S+)  TcpLen: (\d+)/) { ($flags,$seq,$ack,$win,$tcplen) = ($1,$2,$3,$4,$5); }

	if ($line =~ /^$/ )  {
		print "    time=\"$timestamp\", sip=\"$sip\", dip=\"$dip\", class=\"$classification\";\n";
		next;
	}

}

print "}\n";



