/*	test_Memory_Chart_Panel

CVS ID: test_Memory_Chart_Panel.java,v 1.3 2012/04/16 06:23:00 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import PIRL.Viewers.Memory_Chart_Panel;

import	javax.swing.JFrame;
import	javax.swing.JPanel;
import	javax.swing.Timer;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;
import	java.util.Stack;
import	java.util.Random;


public class test_Memory_Chart_Panel
{
static private Memory_Chart_Panel
	Chart;

static private Memory_Use
	Memory_User;


private static class Memory_Use
{
private Timer
	Cycle;
private Random
	Randomizer	= new Random ();
private Stack
	Chunks		= new Stack ();
int
	Total_Used	= 0;


public Memory_Use ()
{
Cycle = new Timer (2000, new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{Use_Memory ();}});
Cycle.start ();
}


private void Use_Memory ()
{
if (Randomizer.nextInt (3) != 0)
	{
	int
		remaining =
			(int)(Chart.Available_Memory ()
				- Chart.Allocated_Memory ()
				+ Chart.Free_Memory ());
	if (remaining > (8 * 1024 * 1024))
		{
		int
			amount = Randomizer.nextInt (remaining);
		try
			{
			Chunks.push (new char[amount]);
			Total_Used += amount;
			System.out.println
				("      Total_Used: " + Total_Used + '\n'
				+"Available_Memory: " + Chart.Available_Memory () + '\n'
				+"Allocated_Memory: " + Chart.Allocated_Memory () + '\n'
				+"     Free_Memory: " + Chart.Free_Memory ());
			return;
			}
		catch (OutOfMemoryError e) {}
		}
	}
if (! Chunks.isEmpty ())
	{
	char[]
		chunk = (char[])Chunks.pop ();
	Chunks.trimToSize ();
	Total_Used -= chunk.length;
	System.out.println
		("      Total_Used: " + Total_Used + '\n'
		+"Available_Memory: " + Chart.Available_Memory () + '\n'
		+"Allocated_Memory: " + Chart.Allocated_Memory () + '\n'
		+"     Free_Memory: " + Chart.Free_Memory ());
	chunk = null;
	System.gc ();
	}
}
}


public static void main
	(
	String[]	arguments
	)
{
System.out.println (Memory_Chart_Panel.ID);

JFrame
	frame = new JFrame ("Memory_Chart_Panel Test");
frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
Chart = new Memory_Chart_Panel ();
Memory_User = new Memory_Use ();
frame.setContentPane (Chart);
frame.pack ();
frame.setVisible (true);
}

}
