/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GENERAL__
#define __GENERAL__

#include <src/global/global.h>

typedef struct general CONTENEUR(General);

#include <src/analyseur/donnees/pilechaine.h>
#include <src/analyseur/donnees/pileentier.h>
#include <src/analyseur/donnees/pilelocalisationfichier.h>
#include <src/analyseur/donnees/filenomfichier.h>
#include <src/problemes/probleme/probleme.h>
#include <src/problemes/verbeux/verbeux.h>
#include <src/donnees/environnement/environnement.h>
#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/option.h>
#include <src/donnees/commandes/localisationfichier.h>
#include <src/donnees/commandes/commandeoption.h>
#include <src/donnees/passes/pilenommacro.h>
#include <src/donnees/styles/styles.h>
#include <src/donnees/idees/idees.h>
#include <src/donnees/sortie/arbreidees.h>
#include <src/donnees/sortie/performancesplan.h>
#include <src/passes/retouches/retouches.h>
#include <src/passes/options/reductionoptions.h>
#include <src/passes/macros/reductionmacros.h>
#include <src/passes/verification/verification.h>
#include <src/passes/styles/enregistrementstyles.h>
#include <src/passes/idees/enregistrementidees.h>
#include <src/passes/plan/plan.h>
#include <src/passes/sortie/sortie.h>

//Bcp d'includes, l...

struct general
{
	//Pointeurs sur toutes les structures dynamiques
	//prsentes dans le compilateur...
	STOCKAGE(Flux) principal;
	//Flux principal de donnes.
	STOCKAGE(FileNomFichier) sources;
	//File des fichiers sources  traiter.
	STOCKAGE(Option) option;
	//Options dfinies en ligne de commande.
	STOCKAGE(LocalisationFichier) localisation;
	//Position de l'analyseur syntaxique lors d'un parcours
	//de l'entre.
	STOCKAGE(PileNomMacro) pilenommacro;
	//Pile des noms de macros utilise lors de l'analyse.
	STOCKAGE(PileChaine) piletexte;
	//Pile des chaine de texte utilise lors de l'analyse.
	STOCKAGE(PileEntier) pileparametre;
	//Pile des numros de paramtre utilise lors de l'analyse.
	STOCKAGE(PileLocalisationFichier) pilelocalisation;
	//Pile de localisation de fichier utilise lors de l'analyse.
	STOCKAGE(Environnement) environnement;
	//Environnement de PlanFacile.
	STOCKAGE_SCALAIRE(Chaine) erreursyntaxe;
	//Chaine utilise lors des erreurs de syntaxe, pour indiquer
	//le token qui a rvl l'erreur.
	STOCKAGE(Retouches) retouches;
	//Structure de donnees utilise pour la gestion de la
	//passe de retouches.
	STOCKAGE(ReductionOptions) reductionoptions;
	//Structure de donnees utilise pour la gestion de la
	//passe de reduction des options.
	STOCKAGE(ReductionMacros) reductionmacros;
	//Structure de donnees utilise pour la gestion de la
	//passe de reduction des macros.
	STOCKAGE(Verification) verification;
	//Structure de donnees utilise pour la gestion de la
	//passe de vrification de flux.
	STOCKAGE(EnregistrementStyles) enregistrementstyles;
	//Structure de donnees utilise pour la gestion de la
	//passe d'enregistrement de styles.
	STOCKAGE(EnregistrementIdees) enregistrementidees;
	//Structure de donnees utilise pour la gestion de la
	//passe d'enregistrement d'ides.
	STOCKAGE(CalculPlan) calculplan;
	//Structure de donnees utilise pour la gestion de la
	//passe de calcul du plan.
	STOCKAGE(Sortie) sortie;
	//Structure utilise pour la gnration de la sortie.
	STOCKAGE(PerformancesPlan) performancesplan;
	//Structure servant  accueillir les informations
	//renvoyes par l'algorithme de calcul du plan.
	STOCKAGE(ArbreIdees) arbreidees;
	//Ides du document organises dans le plan
	//calcul, sous forme de rfrences vers la
	//structure prcdente.
	STOCKAGE(Styles) styles;
	//Styles  appliquer sur la sortie de PlanFacile.
	STOCKAGE(Idees) idees;
	//Ides du document  produire par PlanFacile.
};
/* Structure contenant l'ensemble des donnes gres dynamiquement,
 * en vue de leur suppression en urgence, si le cas se prsente.
 * Les trois fonctions suivantes servent  manipuler la structure
 * en elle-mme, les champs tant laisss  la disposition de
 * l'utilisateur. Cependant, il sera ammen  copier les valeurs
 * aux emplacements prvus, en utilisant *_copie.
 */

Resultat general_initialisation(TRAVAIL(General) general);
/* Cre une structure de gnralit vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si l'allocation choue.
 */

Resultat general_ligne_commande(TRAVAIL(General) general , int argc , char *argv[]);
/* Traite la ligne de commande du compilateur,
 * et place les variables en fonction.
 * Renvoie RESULTAT_ERREUR si general est NULL.
 * Renvoie RESULTAT_ERREUR si general->environnement est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat general_copie_speciale(TRAVAIL(General) general , TRAVAIL(General) copie);
/* Cre une copie de la structure gnrale donne en paramtre.
 * Seulement, cette copie ne contient que la copie de la
 * structure d'environnement.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation,
 * Attention ! Si *copie est diffrent de NULL, la copie tente une
 * destruction pralable de la valeur prsume dans la copie.
 */

Resultat general_copie(TRAVAIL(General) general , TRAVAIL(General) copie);
/* Cre une copie de la structure gnrale donne en paramtre.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation,
 * Attention ! Si *copie est diffrent de NULL, la copie tente une
 * destruction pralable de la valeur prsume dans la copie.
 */

Resultat general_destruction(TRAVAIL(General) general);
/* Dtruit une structure gnrale et tous ses contenus non vides.
 */

#endif
