# - Find Liblbfgs
# Find the native Liblbfgs includes and library
#
#  LIBLBFGS_INCLUDE_DIR - where to find zlib.h, etc.
#  LIBLBFGS_LIBRARIES   - List of libraries when using zlib.
#  LIBLBFGS_FOUND       - True if zlib found.


IF (LIBLBFGS_INCLUDE_DIR)
  # Already in cache, be silent
  SET (liblbfgs_FIND_QUIETLY TRUE)
ENDIF (LIBLBFGS_INCLUDE_DIR)

FIND_PATH(LIBLBFGS_INCLUDE_DIR lbfgs.h)

SET (LIBLBFGS_NAMES lbfgs)
FIND_LIBRARY (LIBLBFGS_LIBRARY NAMES ${LIBLBFGS_NAMES})

# handle the QUIETLY and REQUIRED arguments and set LIBLBFGS_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE (FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS (LIBLBFGS DEFAULT_MSG 
  LIBLBFGS_LIBRARY 
  LIBLBFGS_INCLUDE_DIR)

IF (LIBLBFGS_FOUND)
  SET (LIBLBFGS_LIBRARIES ${LIBLBFGS_LIBRARY})
ELSE (LIBLBFGS_FOUND)
  SET (LIBLBFGS_LIBRARIES)
ENDIF (LIBLBFGS_FOUND)

MARK_AS_ADVANCED (LIBLBFGS_LIBRARY LIBLBFGS_INCLUDE_DIR)
