/*
 *@BEGIN LICENSE
 *
 * PSI4: an ab initio quantum chemistry software package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *@END LICENSE
 */



namespace yeti {

template<typename T>
void
get_quadrature(unsigned short int n, T* t, T* w)
{
    if(n == 0) {
        std::cerr << "You need more coffee.  You asked for a quadrature with 0 points!" << std::endl;
        abort();
    }


    // Fit from 3.0 to 80, unweighted, specifically for separated STO-3G Ne atoms which have denomenators ranging from 5.0 to 75.0, ntest = 250

    if(n == 1) {

        t[0] = 1.2340453349071827;

        w[0] = 4.2565637786054955;

        return;
    }

    if(n == 2) {

        t[0] = 0.14681988755467584;
        t[1] = 2.351471311411014;

        w[0] = 0.5007432011352722;
        w[1] = 5.602738594789986;

        return;
    }

    if(n == 3) {

        t[0] = 3.4639595673412757;
        t[1] = 0.48972418570242726;
        t[2] = 0.0394491257869097;

        w[0] = 6.446784882762581;
        w[1] = 1.0446182626268823;
        w[2] = 0.12520042654356228;

        return;
    }

    if(n == 4) {

        t[0] = 0.2028380391248104;
        t[1] = 1.0502180645934627;
        t[2] = 4.676754975848982;
        t[3] = 0.02360949253300436;

        w[0] = 0.36215813444803524;
        w[1] = 1.6151425081724373;
        w[2] = 7.05245475859932;
        w[3] = 0.06759803733666472;

        return;
    }

    if(n == 5) {

        t[0] = 5.785174256142976;
        t[1] = 0.48481034478785234;
        t[2] = 0.11947567627845217;
        t[3] = 0.017157147125346415;
        t[4] = 1.7033097837174023;

        w[0] = 7.427234445045209;
        w[1] = 0.6345113588807022;
        w[2] = 0.18342109052395952;
        w[3] = 0.046726020740561695;
        w[4] = 2.0729529204997252;

        return;
    }

    if(n == 6) {

        t[0] = 0.013548416211457305;
        t[1] = 0.08460692347605805;
        t[2] = 0.8571759567781906;
        t[3] = 2.39063921530149;
        t[4] = 6.790932848501958;
        t[5] = 0.28986306839688;

        w[0] = 0.036053333229240925;
        w[1] = 0.1171486344455538;
        w[2] = 0.8975377821847531;
        w[3] = 2.422691245105874;
        w[4] = 7.669090017633675;
        w[5] = 0.3282624634077276;

        return;
    }

    if(n == 7) {

        t[0] = 7.702642761417231;
        t[1] = 0.06591482519581919;
        t[2] = 0.526627234010089;
        t[3] = 0.20262892344777705;
        t[4] = 3.07685291884431;
        t[5] = 1.2882111170778299;
        t[6] = 0.011190047723903973;

        w[0] = 7.831158268009431;
        w[1] = 0.08558441609481716;
        w[2] = 0.4828154535222338;
        w[3] = 0.20425370001017518;
        w[4] = 2.6854107800894855;
        w[5] = 1.1299389382424296;
        w[6] = 0.02942087448682253;

        return;
    }

    if(n == 8) {

        t[0] = 3.7441688925870693;
        t[1] = 0.009514272627086286;
        t[2] = 1.752541697961866;
        t[3] = 0.15567396157280275;
        t[4] = 8.532784949007588;
        t[5] = 0.36877990560806934;
        t[6] = 0.815873447931844;
        t[7] = 0.05419347252135458;

        w[0] = 2.8830471979489154;
        w[1] = 0.024840451083328604;
        w[2] = 1.326528725812716;
        w[3] = 0.1439442652136928;
        w[4] = 7.943704893510978;
        w[5] = 0.30169581091615416;
        w[6] = 0.6327443658188738;
        w[7] = 0.06763123315613691;

        return;
    }

    if(n == 9) {

        t[0] = 1.1430809275748197;
        t[1] = 0.2815374585228464;
        t[2] = 9.292841343854622;
        t[3] = 0.5769547538307335;
        t[4] = 0.12678043801273783;
        t[5] = 0.008258364864680793;
        t[6] = 4.384241179357061;
        t[7] = 2.2319593939184292;
        t[8] = 0.04607432753512551;

        w[0] = 0.7703750905688683;
        w[1] = 0.20992248643211533;
        w[2] = 8.024322347305642;
        w[3] = 0.4017281505987773;
        w[4] = 0.11026604460284233;
        w[5] = 0.021466551744658554;
        w[6] = 3.0330245919563583;
        w[7] = 1.489309021385997;
        w[8] = 0.05606687789525973;

        return;
    }

    if(n == 10) {

        t[0] = 0.2276664469492822;
        t[1] = 0.8192543063510765;
        t[2] = 4.9939219033603885;
        t[3] = 0.10720389884935287;
        t[4] = 1.4956055166914304;
        t[5] = 0.04007267679604782;
        t[6] = 0.007281127182028859;
        t[7] = 2.7142354142081686;
        t[8] = 9.992681372943187;
        t[9] = 0.44059630894496915;

        w[0] = 0.15790302857035293;
        w[1] = 0.49873550909550957;
        w[2] = 3.1481885885663217;
        w[3] = 0.08932337863043661;
        w[4] = 0.8926767369254446;
        w[5] = 0.04795287286957137;
        w[6] = 0.018870573567590913;
        w[7] = 1.6228675822975438;
        w[8] = 8.083638543500312;
        w[9] = 0.2797927635310852;

        return;
    }

    if(n == 11) {

        t[0] = 5.572803517544128;
        t[1] = 1.8633740431475263;
        t[2] = 0.006498988725258571;
        t[3] = 3.191508831746731;
        t[4] = 0.03543358462512669;
        t[5] = 10.640549953717139;
        t[6] = 0.3551698606493437;
        t[7] = 0.6284873220577506;
        t[8] = 1.0876816377972913;
        t[9] = 0.09299435897003602;
        t[10] = 0.19144436763363198;

        w[0] = 3.2377594453276943;
        w[1] = 0.9993010752860173;
        w[2] = 0.01680872596534947;
        w[3] = 1.732207171522653;
        w[4] = 0.04191163250005455;
        w[5] = 8.128306151033565;
        w[6] = 0.20897942401666797;
        w[7] = 0.3500294191328681;
        w[8] = 0.5893998156162428;
        w[9] = 0.0751665552503367;
        w[10] = 0.12567024255344877;

        return;
    }

    if(n == 12) {

        t[0] = 11.243304544428094;
        t[1] = 3.65894899853572;
        t[2] = 1.3750465799414229;
        t[3] = 6.121889358066301;
        t[4] = 0.03172986228077635;
        t[5] = 0.5067354709740897;
        t[6] = 0.0821557243860399;
        t[7] = 0.005859031219496855;
        t[8] = 2.2387756009726636;
        t[9] = 0.8402388628486838;
        t[10] = 0.2975486047033947;
        t[11] = 0.16544521788515812;

        w[0] = 8.16262921036872;
        w[1] = 1.8218814611232337;
        w[2] = 0.6721242935052811;
        w[3] = 3.308322837799391;
        w[4] = 0.03721869231051266;
        w[5] = 0.26145926869911;
        w[6] = 0.06496601402506762;
        w[7] = 0.015130858329173104;
        w[8] = 1.0912616983308305;
        w[9] = 0.41806300718627804;
        w[10] = 0.16461889522263745;
        w[11] = 0.10419352270742993;

        return;
    }

    if(n == 13) {

        t[0] = 0.07358007942884416;
        t[1] = 0.6792071706197994;
        t[2] = 0.005325936725312943;
        t[3] = 0.02869931290620466;
        t[4] = 0.42385441452578526;
        t[5] = 0.25631405712728683;
        t[6] = 0.1458269167069973;
        t[7] = 1.675275101104895;
        t[8] = 6.642790499217862;
        t[9] = 2.616220900834212;
        t[10] = 1.070914559175056;
        t[11] = 11.80658380444537;
        t[12] = 4.1137061166141615;

        w[0] = 0.05724991247523269;
        w[1] = 0.313562953966485;
        w[2] = 0.013738751753909581;
        w[3] = 0.03345632395733276;
        w[4] = 0.2050779477246034;
        w[5] = 0.1350371447373635;
        w[6] = 0.08900724504699976;
        w[7] = 0.746426448863205;
        w[8] = 3.3645924422510842;
        w[9] = 1.1701315751624095;
        w[10] = 0.4822696823029514;
        w[11] = 8.189469943286456;
        w[12] = 1.895719335155862;

        return;
    }


    // if we get to here, the user is asking too much
    std::cerr << "Too many points asked for in yeti::get_quadrature().  No quadrature scheme known for " << n << " points." << std::endl;
    abort();
    
}

} // End namespace yeti
