#!/usr/bin/python

"""Helper routines."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import datetime

def read_file_as_array(filename, delim = None):
	"""Return the contents of a file as an array of arrays."""
	lines = []
	fp = None
	try:
		fp = open(filename)
	except:
		return None
	try:
		try:
			for line in fp:
				lines.append(line.split(delim))
		except:
			return None
		return lines
	finally:
		fp.close()

def read_line_as_array(filename):
	"""Return the first line of a file as an array."""
	x = read_file_as_array(filename)
	if x == None:
		return None
	return x[0]

def write_file(filename, data):
	"""Write some data to a sysfs file."""
	fp = None
	try:
		fp = open(filename, "w")
	except:
		return False
	try:
		try:
			fp.write(data)
		except:
			return False
		return True
	finally:
		fp.close()

def cmp_string_as_number(xs, ys):
	"""Compare two strings numerically."""
	x = int(xs)
	y = int(ys)
	return x - y
