# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RequestReportRecordContract(Model):
    """Request Report data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param api_id: API identifier path. /apis/{apiId}
    :type api_id: str
    :param operation_id: Operation identifier path.
     /apis/{apiId}/operations/{operationId}
    :type operation_id: str
    :ivar product_id: Product identifier path. /products/{productId}
    :vartype product_id: str
    :ivar user_id: User identifier path. /users/{userId}
    :vartype user_id: str
    :param method: The HTTP method associated with this request..
    :type method: str
    :param url: The full URL associated with this request.
    :type url: str
    :param ip_address: The client IP address associated with this request.
    :type ip_address: str
    :param backend_response_code: The HTTP status code received by the gateway
     as a result of forwarding this request to the backend.
    :type backend_response_code: str
    :param response_code: The HTTP status code returned by the gateway.
    :type response_code: int
    :param response_size: The size of the response returned by the gateway.
    :type response_size: int
    :param timestamp: The date and time when this request was received by the
     gateway in ISO 8601 format.
    :type timestamp: datetime
    :param cache: Specifies if response cache was involved in generating the
     response. If the value is none, the cache was not used. If the value is
     hit, cached response was returned. If the value is miss, the cache was
     used but lookup resulted in a miss and request was fulfilled by the
     backend.
    :type cache: str
    :param api_time: The total time it took to process this request.
    :type api_time: float
    :param service_time: he time it took to forward this request to the
     backend and get the response back.
    :type service_time: float
    :param api_region: Azure region where the gateway that processed this
     request is located.
    :type api_region: str
    :param subscription_id: Subscription identifier path.
     /subscriptions/{subscriptionId}
    :type subscription_id: str
    :param request_id: Request Identifier.
    :type request_id: str
    :param request_size: The size of this request..
    :type request_size: int
    """

    _validation = {
        'product_id': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'api_id': {'key': 'apiId', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'product_id': {'key': 'productId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'backend_response_code': {'key': 'backendResponseCode', 'type': 'str'},
        'response_code': {'key': 'responseCode', 'type': 'int'},
        'response_size': {'key': 'responseSize', 'type': 'int'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'cache': {'key': 'cache', 'type': 'str'},
        'api_time': {'key': 'apiTime', 'type': 'float'},
        'service_time': {'key': 'serviceTime', 'type': 'float'},
        'api_region': {'key': 'apiRegion', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'request_size': {'key': 'requestSize', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RequestReportRecordContract, self).__init__(**kwargs)
        self.api_id = kwargs.get('api_id', None)
        self.operation_id = kwargs.get('operation_id', None)
        self.product_id = None
        self.user_id = None
        self.method = kwargs.get('method', None)
        self.url = kwargs.get('url', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.backend_response_code = kwargs.get('backend_response_code', None)
        self.response_code = kwargs.get('response_code', None)
        self.response_size = kwargs.get('response_size', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.cache = kwargs.get('cache', None)
        self.api_time = kwargs.get('api_time', None)
        self.service_time = kwargs.get('service_time', None)
        self.api_region = kwargs.get('api_region', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.request_id = kwargs.get('request_id', None)
        self.request_size = kwargs.get('request_size', None)
