# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventsClientInfo(Model):
    """Client info for an event result.

    :param model: Model of the client
    :type model: str
    :param os: Operating system of the client
    :type os: str
    :param type: Type of the client
    :type type: str
    :param browser: Browser of the client
    :type browser: str
    :param ip: IP address of the client
    :type ip: str
    :param city: City of the client
    :type city: str
    :param state_or_province: State or province of the client
    :type state_or_province: str
    :param country_or_region: Country or region of the client
    :type country_or_region: str
    """

    _attribute_map = {
        'model': {'key': 'model', 'type': 'str'},
        'os': {'key': 'os', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'browser': {'key': 'browser', 'type': 'str'},
        'ip': {'key': 'ip', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state_or_province': {'key': 'stateOrProvince', 'type': 'str'},
        'country_or_region': {'key': 'countryOrRegion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EventsClientInfo, self).__init__(**kwargs)
        self.model = kwargs.get('model', None)
        self.os = kwargs.get('os', None)
        self.type = kwargs.get('type', None)
        self.browser = kwargs.get('browser', None)
        self.ip = kwargs.get('ip', None)
        self.city = kwargs.get('city', None)
        self.state_or_province = kwargs.get('state_or_province', None)
        self.country_or_region = kwargs.get('country_or_region', None)
