/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKEDATA_H
#define FAKEDATA_H

#include <QImage>
#include <QObject>
#include <QPoint>
#include <QSize>
#include <QTimer>

class FakeData: public QObject
{
    Q_OBJECT
public:
    FakeData();

    QImage viewfinderFrame() const;
    QImage previewFrame() const;
    QImage capturedImage() const;

    void setViewfinderSize(const QSize &size);
    const QSize& viewfinderSize() const;
    void setZoomFactor(double zoom);
    void startMove();
    void stopMove();

    void setSelectedCamera(int idx);

Q_SIGNALS:
    void newViewfinderFrame();

private Q_SLOTS:
    void updatePosition();

private:
    QImage rawFrame() const;

    QImage m_rawData;
    int m_frameWidth;
    int m_frameHeight;
    QPoint m_offset;
    QTimer m_cameraShake;
    double m_movecounter;
    QSize m_viewfinderSize;
    QSize m_imageSize;
    double m_zoomFactor;
};

#endif // FAKEDATA_H
