% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowAnyNAs.R
\name{rowAnyNAs}
\alias{rowAnyNAs}
\alias{rowAnyNAs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowAnyNAs,ANY-method}
\alias{colAnyNAs}
\alias{colAnyNAs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colAnyNAs,ANY-method}
\title{Check if any elements in a row (column) of a matrix-like object is missing}
\usage{
rowAnyNAs(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{rowAnyNAs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{rowAnyNAs}{ANY}(x, rows = NULL, cols = NULL, ..., useNames = NA)

colAnyNAs(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{colAnyNAs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{colAnyNAs}{ANY}(x, rows = NULL, cols = NULL, ..., useNames = NA)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{logical}} \code{\link{vector}} of length N (K).
}
\description{
Check if any elements in a row (column) of a matrix-like object is missing.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowAnyNAs}
/ \code{matrixStats::colAnyNAs}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowAnyNAs(mat)
  colAnyNAs(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:anyMissing]{rowAnyNAs}()} and
\code{matrixStats::\link[matrixStats:anyMissing]{colAnyNAs}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if any element is equal to a value, see
\code{\link{rowAnys}()}.
\item \code{base::\link{is.na}()} and \code{base::\link{any}()}.
}
}
