% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerDetectSomatic.R
\name{calculatePowerDetectSomatic}
\alias{calculatePowerDetectSomatic}
\title{Power calculation for detecting somatic mutations}
\usage{
calculatePowerDetectSomatic(
  coverage,
  f = NULL,
  purity = NULL,
  ploidy = NULL,
  cell.fraction = 1,
  error = 0.001,
  fpr = 5e-07,
  verbose = TRUE
)
}
\arguments{
\item{coverage}{Mean sequencing coverage.}

\item{f}{Mean expected allelic fraction. If \code{NULL}, requires purity and
ploidy and then calculates the expected fraction.}

\item{purity}{Purity of sample. Only required when \code{f} is \code{NULL}.}

\item{ploidy}{Ploidy of sample. Only required when \code{f} is \code{NULL}.}

\item{cell.fraction}{Fraction of cells harboring mutation. Ignored if
\code{f} is not \code{NULL}.}

\item{error}{Estimated sequencing error rate.}

\item{fpr}{Required false positive rate for mutation vs. sequencing error.}

\item{verbose}{Verbose output.}
}
\value{
A list with elements \item{power}{Power to detect somatic
mutations.} \item{k}{Minimum number of supporting reads.} \item{f}{Expected
allelic fraction. }
}
\description{
This function calculates the probability of correctly rejecting the null
hypothesis that an alt allele is a sequencing error rather than a true
(mono-)clonal mutation.
}
\examples{

purity <- c(0.1, 0.15, 0.2, 0.25, 0.4, 0.6, 1)
coverage <- seq(5, 35, 1)
power <- lapply(purity, function(p) sapply(coverage, function(cv)
    calculatePowerDetectSomatic(coverage = cv, purity = p, ploidy = 2,
    verbose = FALSE)$power))

# Figure S7b in Carter et al.
plot(coverage, power[[1]], col = 1, xlab = "Sequence coverage",
    ylab = "Detection power", ylim = c(0, 1), type = "l")

for (i in 2:length(power)) lines(coverage, power[[i]], col = i)
abline(h = 0.8, lty = 2, col = "grey")
legend("bottomright", legend = paste("Purity", purity),
    fill = seq_along(purity))

# Figure S7c in Carter et al.
coverage <- seq(5, 350, 1)
power <- lapply(purity, function(p) sapply(coverage, function(cv)
    calculatePowerDetectSomatic(coverage = cv, purity = p, ploidy = 2,
        cell.fraction = 0.2, verbose = FALSE)$power))
plot(coverage, power[[1]], col = 1, xlab = "Sequence coverage",
    ylab = "Detection power", ylim = c(0, 1), type = "l")

for (i in 2:length(power)) lines(coverage, power[[i]], col = i)
abline(h = 0.8, lty = 2, col = "grey")
legend("bottomright", legend = paste("Purity", purity),
    fill = seq_along(purity))

}
\references{
Carter et al. (2012), Absolute quantification of somatic DNA
alterations in human cancer. Nature Biotechnology.
}
\author{
Markus Riester
}
