setMethod(readGAlignmentsFromBam, "character",
          function(file, index=file, ..., use.names=FALSE, param=NULL,
                   with.which_label=FALSE)
{
    if (missing(index) && (is.null(param) || 0L == length(bamWhich(param))))
        index <- character(0)
    bam <- open(BamFile(file, index), "rb")
    on.exit(close(bam))
    readGAlignmentsFromBam(bam, character(), ..., use.names=use.names,
                           param=param, with.which_label=with.which_label)
})

setMethod(readGappedReadsFromBam, "character",
          function(file, index=file, use.names=FALSE, param=NULL,
                   with.which_label=FALSE)
{
    if (missing(index) && (is.null(param) || 0L == length(bamWhich(param))))
        index <- character(0)
    bam <- open(BamFile(file, index), "rb")
    on.exit(close(bam))
    readGappedReadsFromBam(bam, character(), use.names=use.names,
                           param=param, with.which_label=with.which_label)
})

setMethod(readGAlignmentPairsFromBam, "character",
          function(file, index=file, use.names=FALSE, param=NULL,
                   with.which_label=FALSE)
{
    if (missing(index) && (is.null(param) || 0L == length(bamWhich(param))))
        index <- character(0)
    bam <- open(BamFile(file, index), "rb")
    on.exit(close(bam))
    readGAlignmentPairsFromBam(bam, character(), use.names=use.names,
                               param=param, with.which_label=with.which_label)
})

setMethod(readGAlignmentsListFromBam, "character",
          function(file, index=file, ..., use.names=FALSE, 
                   param=ScanBamParam(), with.which_label=FALSE)
{
    if (missing(index) && (is.null(param) || 0L == length(bamWhich(param))))
        index <- character(0)
    bam <- open(BamFile(file, index, asMates=TRUE), "rb")
    on.exit(close(bam))
    readGAlignmentsListFromBam(bam, character(), use.names=use.names, 
                               param=param, with.which_label=with.which_label)
})

