% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmADMB_tidiers.R
\name{glmmadmb_tidiers}
\alias{glmmadmb_tidiers}
\alias{glmmADMB_tidiers}
\alias{tidy.glmmadmb}
\alias{augment.glmmadmb}
\alias{glance.glmmadmb}
\title{Tidying methods for glmmADMB models}
\usage{
\method{tidy}{glmmadmb}(
  x,
  effects = c("fixed", "ran_pars"),
  component = "cond",
  scales = NULL,
  ran_prefix = NULL,
  conf.int = FALSE,
  conf.level = 0.95,
  conf.method = "Wald",
  ...
)

\method{augment}{glmmadmb}(x, data = stats::model.frame(x), newdata, ...)

\method{glance}{glmmadmb}(x, ...)
}
\arguments{
\item{x}{An object of class \code{glmmadmb}
\code{glmer}, or \code{nlmer}}

\item{effects}{A character vector including one or more of "fixed" (fixed-effect parameters), "ran_pars" (variances and covariances or standard deviations and correlations of random effect terms) or "ran_vals" (conditional modes/BLUPs/latent variable estimates)}

\item{component}{Which component(s) to report for (e.g., conditional, zero-inflation, dispersion: at present only works for "cond")}

\item{scales}{scales on which to report the variables: for random effects, the choices are \sQuote{"sdcor"} (standard deviations and correlations: the default if \code{scales} is \code{NULL}) or \sQuote{"varcov"} (variances and covariances). \code{NA} means no transformation, appropriate e.g. for fixed effects; inverse-link transformations (exponentiation
or logistic) are not yet implemented, but may be in the future.}

\item{ran_prefix}{a length-2 character vector specifying the strings to use as prefixes for self- (variance/standard deviation) and cross- (covariance/correlation) random effects terms}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{conf.method}{method for computing confidence intervals (see \code{\link[lme4]{confint.merMod}})}

\item{...}{extra arguments (not used)}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed}

\item{newdata}{new data to be used for prediction; optional}
}
\value{
All tidying methods return a \code{tbl_df} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect, either
with groups depending on the \code{effects} parameter.
It contains the columns
  \item{group}{the group within which the random effect is being estimated: \code{NA} for fixed effects}
  \item{level}{level within group (\code{NA} except for modes)}
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}
  \item{std.error}{standard error}
  \item{statistic}{t- or Z-statistic (\code{NA} for modes)}
  \item{p.value}{P-value computed from t-statistic (may be missing/NA)}

\code{augment} returns one row for each original observation,
with columns (each prepended by a .) added. Included are the columns
  \item{.fitted}{predicted values}
  \item{.resid}{residuals}
  \item{.fixed}{predicted values with no random effects}

Also added for "merMod" objects, but not for "mer" objects,
are values from the response object within the model (of type
\code{lmResp}, \code{glmResp}, \code{nlsResp}, etc). These include \code{".mu",
".offset", ".sqrtXwt", ".sqrtrwt", ".eta"}.

\code{glance} returns one row with the columns
  \item{sigma}{the square root of the estimated residual variance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
}
\description{
These methods tidy the coefficients of \code{glmmADMB} models
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{

if (require("glmmADMB") && require("lme4")) {
    ## original model
    \dontrun{
        data("sleepstudy", package="lme4")
        lmm1 <- glmmadmb(Reaction ~ Days + (Days | Subject), sleepstudy,
                         family="gaussian")
    }
    ## load stored object
    load(system.file("extdata","glmmADMB_example.rda",package="broom.mixed"))
    tidy(lmm1, effects = "fixed")
    tidy(lmm1, effects = "fixed", conf.int=TRUE)
    ## tidy(lmm1, effects = "fixed", conf.int=TRUE, conf.method="profile")
    ## tidy(lmm1, effects = "ran_vals", conf.int=TRUE)
    head(augment(lmm1, sleepstudy))
    glance(lmm1)

    glmm1 <- glmmadmb(cbind(incidence, size - incidence) ~ period + (1 | herd),
                  data = cbpp, family = "binomial")
    tidy(glmm1)
    tidy(glmm1, effects = "fixed")
    head(augment(glmm1, cbpp))
    glance(glmm1)

}
}
\seealso{
\link{na.action}
}
