% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qassertr.r
\name{qassertr}
\alias{qassertr}
\alias{qtestr}
\title{Quick recursive arguments checks on lists and data frames}
\usage{
qassertr(x, rules, .var.name)

qtestr(x, rules)
}
\arguments{
\item{x}{[\code{list} or \code{data.frame}]\cr
List or data frame to check for compliance with at least one of \code{rules}.
See details of \code{\link{qtest}} for rule explanation.}

\item{rules}{[\code{character}]\cr
Set of rules. See \code{\link{qtest}}}

\item{.var.name}{[\code{logical(1)}]\cr
Argument name to print in error message. If missing,
the name of \code{x} will be retrieved via \code{\link[base]{substitute}}.}
}
\value{
[logical(1)]: \code{TRUE} on success, \code{FALSE} (or a thrown exception) otherwise.
}
\description{
These functions are the tuned counterparts of \code{\link{qtest}} and
\code{\link{qassert}} tailored for recursive checks of list
elements or data frame columns.
}
\examples{
qtestr(as.list(1:10), "i+")
qtestr(iris, "n")
}
\seealso{
\code{\link{qtest}}, \code{\link{qassert}}
}

