% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l1pca.R
\docType{class}
\name{PCA_L1-class}
\alias{PCA_L1-class}
\alias{PCA_L1}
\title{Principal Component Analysis with L1 error.}
\description{
S4 Class implementing PCA with L1 error.
}
\details{
PCA transforms the data so that the L2 reconstruction error is minimized or
the variance of the projected data is maximized. This is sensitive to
outliers, L1 PCA minimizes the L1 reconstruction error or maximizes the sum
of the L1 norm of the projected observations.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

PCA can take the following parameters:
\describe{
  \item{ndim}{The number of output dimensions.}
  \item{center}{logical, should the data be centered, defaults to \code{TRUE}.}
  \item{scale.}{logical, should the data be scaled, defaults to \code{FALSE}.}
  \item{fun}{character or function, the method to apply, see the \code{pcaL1} package}
  \item{\ldots}{other parameters for \code{fun}}
}
}

\section{Implementation}{


Wraps around the different methods is the \code{pcaL1} package. Because PCA
can be reduced to a simple rotation, forward and backward projection
functions are supplied.
}

\examples{
if(requireNamespace("pcaL1", quietly = TRUE)) {
dat <- loadDataSet("Iris")

## using the S4 Class
pca_l1 <- PCA_L1()
emb <- pca_l1@fun(dat, pca_l1@stdpars)

## using embed()
emb2 <- embed(dat, "PCA_L1")

plot(emb, type = "2vars")
plot(emb@inverse(emb@data), type = "3vars")
}

}
\references{
Park, Y.W., Klabjan, D., 2016. Iteratively Reweighted Least Squares
Algorithms for L1-Norm Principal Component Analysis, in: Data Mining (ICDM),
2016 IEEE 16th International Conference On. IEEE, pp. 430-438.
}
\seealso{
Other dimensionality reduction methods: \code{\link{AutoEncoder-class}},
  \code{\link{DRR-class}},
  \code{\link{DiffusionMaps-class}},
  \code{\link{DrL-class}}, \code{\link{FastICA-class}},
  \code{\link{FruchtermanReingold-class}},
  \code{\link{HLLE-class}}, \code{\link{Isomap-class}},
  \code{\link{KamadaKawai-class}}, \code{\link{LLE-class}},
  \code{\link{MDS-class}}, \code{\link{NNMF-class}},
  \code{\link{PCA-class}}, \code{\link{UMAP-class}},
  \code{\link{dimRedMethod-class}},
  \code{\link{dimRedMethodList}}, \code{\link{kPCA-class}},
  \code{\link{nMDS-class}}, \code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
